/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeSiteAdvancedSettings;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeArrayManager;
import com.vmware.srm.client.impex.configurables.basicInfo.Summary;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.srm.client.impex.configurables.mappings.IeMappings;
import com.vmware.srm.client.impex.configurables.placeholderDatastores.IePlaceholderDatastores;
import com.vmware.srm.client.impex.configurables.vmSettings.IeVmSettings;
import com.vmware.srm.client.impex.exporters.advancedSettings.SiteAdvancedSettingsExporter;
import com.vmware.srm.client.impex.exporters.arrayManagers.ArrayManagersExporter;
import com.vmware.srm.client.impex.exporters.basicInfo.SummaryExporter;
import com.vmware.srm.client.impex.exporters.folders.ProtectionGroupFoldersExporter;
import com.vmware.srm.client.impex.exporters.folders.RecoveryPlanFoldersExporter;
import com.vmware.srm.client.impex.exporters.inventory.SrmInventoryExporter;
import com.vmware.srm.client.impex.exporters.mappings.MappingsExporter;
import com.vmware.srm.client.impex.exporters.placeholderDatastores.PlaceholderDatastoresExporter;
import com.vmware.srm.client.impex.exporters.vmSettings.VmSettingsExporter;
import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import com.vmware.srm.client.reactive.Promise;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlExporterHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlExporterHelper.class);
    private final ConfigurablesWrapper _configurablesWrapper;

    public XmlExporterHelper(ConfigurablesWrapper configurablesWrapper) {
        this._configurablesWrapper = configurablesWrapper;
    }

    public Promise<List<IeInventoryTree>> exportInventoryForSrm() {
        LOGGER.debug("Srm inventory export started.");
        return new SrmInventoryExporter().getConfigurables().thenApply(inventory -> {
            LOGGER.debug("Srm inventory export ended.");
            this._configurablesWrapper.setInventory((List<? extends Configurable>)inventory);
            return inventory;
        });
    }

    public Promise<List<IeMappings>> exportMappings() {
        LOGGER.debug("Mappings export started.");
        return new MappingsExporter().getConfigurables().thenApply(mappings -> {
            LOGGER.debug("Mappings export ended.");
            this._configurablesWrapper.setMappings((List<? extends Configurable>)mappings);
            return mappings;
        });
    }

    public Promise<List<IePlaceholderDatastores>> exportPlaceholderDatastores() {
        LOGGER.debug("Placeholder export started.");
        return new PlaceholderDatastoresExporter().getConfigurables().thenApply(placeholders -> {
            LOGGER.debug("Placeholder export ended.");
            this._configurablesWrapper.setPlaceholders((List<? extends Configurable>)placeholders);
            return placeholders;
        });
    }

    public Promise<List<IeArrayManager>> exportArrayManagers() {
        LOGGER.debug("Array managers export started.");
        return new ArrayManagersExporter().getConfigurables().thenApply(arrayManagers -> {
            LOGGER.debug("Array managers export ended.");
            this._configurablesWrapper.setArrayManagers((List<? extends Configurable>)arrayManagers);
            return null;
        });
    }

    public Promise<List<IeFolder>> exportProtectionGroups() {
        LOGGER.debug("Protection group folders export started.");
        return new ProtectionGroupFoldersExporter().getConfigurables().thenApply(groupFolders -> {
            LOGGER.debug("Protection group folders export ended.");
            this._configurablesWrapper.setProtectionGroupFolders((List<? extends Configurable>)groupFolders);
            return groupFolders;
        });
    }

    public Promise<List<IeFolder>> exportRecoveryPlans() {
        LOGGER.debug("Recovery plan folders export started.");
        return new RecoveryPlanFoldersExporter().getConfigurables().thenApply(planFolders -> {
            LOGGER.debug("Recovery plan folders export ended.");
            this._configurablesWrapper.setRecoveryPlanFolders((List<? extends Configurable>)planFolders);
            return planFolders;
        });
    }

    public Promise<List<IeVmSettings>> exportVmRecoverySettings() {
        LOGGER.debug("VM recovery settings export started.");
        return new VmSettingsExporter().getConfigurables().thenApply(allVmSettings -> {
            LOGGER.debug("VM recovery settings export ended.");
            this._configurablesWrapper.setVmSettings((List<? extends Configurable>)allVmSettings);
            return allVmSettings;
        });
    }

    public Promise<List<IeSiteAdvancedSettings>> exportAdvancedSettings() {
        LOGGER.debug("Advanced settings export started.");
        return new SiteAdvancedSettingsExporter().getConfigurables().thenApply(advancedSettings -> {
            LOGGER.debug("Advanced settings export ended.");
            this._configurablesWrapper.setSiteAdvancedSettings((List<? extends Configurable>)advancedSettings);
            return advancedSettings;
        });
    }

    public Promise<Summary> exportSummary() {
        LOGGER.debug("Details export started.");
        return new SummaryExporter().getConfigurables().thenApply(summaries -> {
            if (summaries.size() != 1) {
                LOGGER.debug("Exporting summary produced: {} result(s): {}", (Object)summaries.size(), summaries);
                throw new RuntimeException(String.format("Exporting summary produced: %s result(s).", summaries.size()));
            }
            LOGGER.debug("Details export ended.");
            Summary summary = (Summary)summaries.get(0);
            this._configurablesWrapper.setSummary(summary);
            return summary;
        });
    }
}

