/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl;

import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SoapHelper {
    public static void outputHeader(Marshaller marshaller, XMLStreamWriter xmlOut, Map<String, Object> context, VmodlVersion version, VmodlContext vmodlContext) throws MarshallException, XMLStreamException {
        if (null != context && !context.isEmpty()) {
            xmlOut.setDefaultNamespace(Constants.HEADER_QNAME.getNamespaceURI());
            xmlOut.writeStartElement(Constants.HEADER_QNAME.getPrefix(), Constants.HEADER_QNAME.getLocalPart(), Constants.HEADER_QNAME.getNamespaceURI());
            Set<String> keys = context.keySet();
            VmodlFieldImpl vmodlField = new VmodlFieldImpl(vmodlContext);
            vmodlField.setVersion(version);
            for (String key : keys) {
                vmodlField.setName(key);
                Object value = context.get(key);
                if (value instanceof String) {
                    xmlOut.writeStartElement(key);
                    xmlOut.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "string");
                    xmlOut.writeCharacters((String)value);
                    xmlOut.writeEndElement();
                    continue;
                }
                marshaller.marshal((VmodlField)vmodlField, value, xmlOut);
            }
            xmlOut.writeEndElement();
        }
    }

    public static void outputEnvelopeStart(XMLStreamWriter xmlOut) throws XMLStreamException {
        xmlOut.writeStartDocument();
        xmlOut.writeStartElement(Constants.ENV_QNAME.getPrefix(), Constants.ENV_QNAME.getLocalPart(), Constants.ENV_QNAME.getNamespaceURI());
        xmlOut.writeNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        xmlOut.writeNamespace("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        xmlOut.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xmlOut.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public static void outputBodyStart(XMLStreamWriter xmlOut) throws XMLStreamException {
        xmlOut.writeStartElement(Constants.BODY_QNAME.getPrefix(), Constants.BODY_QNAME.getLocalPart(), Constants.BODY_QNAME.getNamespaceURI());
    }

    public static void outputElementStart(XMLStreamWriter xmlOut, String localName, String namespace, boolean marshallNamespace) throws XMLStreamException {
        xmlOut.writeStartElement(localName);
        xmlOut.writeAttribute("xmlns", "urn:" + namespace);
        if (marshallNamespace) {
            xmlOut.writeNamespace(namespace, "urn:" + namespace);
        }
    }
}

