/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingUtil {
    private static Log _logger = LogFactory.getLog(LoggingUtil.class);

    public static synchronized void generateThreadDump() {
        if (_logger.isErrorEnabled()) {
            ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
            _logger.error((Object)"JVM thread dump:");
            for (ThreadInfo threadInfo : threadInfos) {
                StackTraceElement[] stackTraceElements;
                StringBuilder threadDump = new StringBuilder();
                threadDump.append("\"");
                threadDump.append(threadInfo.getThreadName());
                threadDump.append("\"\n   java.lang.Thread.State: ");
                threadDump.append((Object)threadInfo.getThreadState());
                for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                    threadDump.append("\n        at ");
                    threadDump.append(stackTraceElement);
                }
                threadDump.append("\n");
                _logger.error((Object)threadDump.toString());
            }
        }
    }
}

