/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.srm.client.reactive.Subscriber;
import com.vmware.srm.client.reactive.Subscription;
import com.vmware.srm.client.reactive.impl.PublisherImpl;
import com.vmware.srm.client.reactive.impl.StreamImpl;
import com.vmware.srm.client.reactive.impl.SubscriberWrapper;
import com.vmware.srm.client.reactive.impl.SyncDispatcherImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class CachingStream<T>
extends StreamImpl<T> {
    private final Impl _impl = new Impl();
    private final Node<T> _head = new Node<Object>(null);

    public CachingStream() {
        super.subscribe(this._impl);
    }

    @Override
    public Subscription<T> subscribe(Subscriber<? super T> subscriber) {
        Wrapper<T> wrapper = new Wrapper<T>(subscriber);
        Subscription<? super T> subscription = this._impl.subscribe(wrapper);
        Node<T> lastKnown = this._head;
        while (true) {
            wrapper.record();
            Node<T> last = CachingStream.getLast(lastKnown);
            if (last == lastKnown) {
                wrapper.play();
                return subscription;
            }
            wrapper.discard();
            Node<T> node = lastKnown;
            lastKnown = last;
            do {
                node = node.next.get();
                wrapper.publish(node);
            } while (node != last);
            last.waitToPublish();
        }
    }

    private static <T> void enqueue(Node<T> node, Node<T> head) {
        Node<T> last = head;
        do {
            last = CachingStream.getLast(last);
        } while (!last.next.compareAndSet(null, node));
    }

    private static <T> Node<T> getLast(Node<T> head) {
        Node<T> last = head;
        Node node = last.next.get();
        while (node != null) {
            last = node;
            node = node.next.get();
        }
        return last;
    }

    private static final class Node<T> {
        final T item;
        final boolean complete;
        final boolean cancelled;
        final Exception err;
        final AtomicReference<Node<T>> next = new AtomicReference<Object>(null);
        private final CountDownLatch _publishedWaiter = new CountDownLatch(1);

        Node(T item) {
            this.item = item;
            this.complete = false;
            this.cancelled = false;
            this.err = null;
        }

        Node(boolean cancelled) {
            this.item = null;
            this.complete = true;
            this.cancelled = cancelled;
            this.err = null;
        }

        Node(Exception err) {
            this.item = null;
            this.complete = true;
            this.cancelled = false;
            this.err = err;
        }

        void publish(Subscriber<T> subscriber) {
            if (this.complete) {
                if (this.err == null) {
                    subscriber.onComplete(this.cancelled);
                } else {
                    subscriber.onError(this.err);
                }
            } else {
                subscriber.onNext(this.item);
            }
        }

        void setPublished() {
            this._publishedWaiter.countDown();
        }

        void waitToPublish() {
            try {
                this._publishedWaiter.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    private static class Wrapper<T>
    implements Subscriber<T> {
        private static final int DISCARD = 0;
        private static final int RECORD = 1;
        private static final int REPLAY = 2;
        private static final int PLAY = 3;
        private final Subscriber<T> _subscriber;
        private final Subscriber<? super T> _original;
        private volatile int _state = 0;
        private final List<Node<T>> _buffer = new ArrayList<Node<T>>();

        Wrapper(Subscriber<? super T> subscriber) {
            this._subscriber = new SubscriberWrapper<T>(subscriber);
            this._original = subscriber;
        }

        public boolean equals(Object obj) {
            return this._original.equals(obj);
        }

        public int hashCode() {
            return this._original.hashCode();
        }

        @Override
        public void onNext(T item) {
            this.process(new Node<T>(item));
        }

        @Override
        public void onComplete(boolean cancelled) {
            this.process(new Node(cancelled));
        }

        @Override
        public void onError(Exception err) {
            this.process(new Node(err));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void process(Node<T> node) {
            if (this._state == 0) {
                return;
            }
            if (this._state == 3) {
                node.publish(this._subscriber);
                return;
            }
            List<Node<T>> list = this._buffer;
            synchronized (list) {
                if (this._state == 0) {
                    return;
                }
                if (this._state < 3) {
                    this._buffer.add(node);
                    return;
                }
            }
            node.publish(this._subscriber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void record() {
            List<Node<T>> list = this._buffer;
            synchronized (list) {
                this._buffer.clear();
            }
            this._state = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void play() {
            this._state = 2;
            block2: while (true) {
                Node[] nodeArray = this._buffer;
                // MONITORENTER : this._buffer
                if (this._buffer.isEmpty()) {
                    this._state = 3;
                    // MONITOREXIT : nodeArray
                    return;
                }
                Node[] nodes = this._buffer.toArray(new Node[this._buffer.size()]);
                this._buffer.clear();
                // MONITOREXIT : nodeArray
                nodeArray = nodes;
                int n = nodeArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    Node node = nodeArray[n2];
                    node.publish(this._subscriber);
                    ++n2;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void discard() {
            this._state = 0;
            List<Node<T>> list = this._buffer;
            synchronized (list) {
                this._buffer.clear();
            }
        }

        void publish(Node<T> node) {
            node.publish(this._subscriber);
        }
    }

    private class Impl
    extends PublisherImpl<T>
    implements Subscriber<T> {
        Impl() {
            super(new SyncDispatcherImpl());
        }

        @Override
        public void onNext(T item) {
            Node node = new Node(item);
            CachingStream.enqueue(node, CachingStream.this._head);
            this.publishNext(item);
            node.setPublished();
        }

        @Override
        public void onComplete(boolean cancelled) {
            Node node = new Node(false);
            CachingStream.enqueue(node, CachingStream.this._head);
            this.publishComplete();
            node.setPublished();
        }

        @Override
        public void onError(Exception err) {
            Node node = new Node(err);
            CachingStream.enqueue(node, CachingStream.this._head);
            this.publishError(err);
            node.setPublished();
        }
    }
}

