/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Subscriber;
import com.vmware.srm.client.reactive.impl.TransformStream;
import com.vmware.srm.client.reactive.impl.utils.Exceptions;
import java.util.function.Predicate;

class FilterTransformStream<U>
extends TransformStream<U, U> {
    private final Predicate<? super U> _predicate;

    protected FilterTransformStream(Publisher<U> publisher, Predicate<? super U> predicate) {
        super(publisher);
        this._predicate = predicate;
    }

    @Override
    protected void processNext(U item, Subscriber<? super U> subscriber) {
        boolean test;
        try {
            test = this._predicate.test(item);
        }
        catch (Throwable t) {
            subscriber.onError(Exceptions.wrap(t));
            return;
        }
        if (test) {
            subscriber.onNext(item);
        }
    }
}

