/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.srm.client.reactive.Dispatcher;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.PromiseResult;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Subscriber;
import com.vmware.srm.client.reactive.Subscription;
import com.vmware.srm.client.reactive.impl.AsyncDispatcherImpl;
import com.vmware.srm.client.reactive.impl.SubscriberWrapper;
import com.vmware.srm.client.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.utilities.ThreadContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromiseImpl<T>
implements Promise<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromiseImpl.class);
    private static final Dispatcher DUMMY_DISPATCHER = new Dispatcher(){

        @Override
        public void dispatch(Runnable task) {
        }
    };
    private final AtomicReference<Result<T>> _resultRef = new AtomicReference<Object>(null);
    private final Dispatcher _dispatcher = new AsyncDispatcherImpl();
    private final AtomicReference<Completion<T, ?>> _headRef = new AtomicReference<2>(new Completion<T, Void>(DUMMY_DISPATCHER){

        @Override
        Promise<Void> getResultPromise() {
            throw new UnsupportedOperationException();
        }

        @Override
        void complete(T value) {
        }

        @Override
        void complete(Exception err) {
        }
    });

    @Override
    public Subscription<T> subscribe(final Subscriber<? super T> subscriber) {
        final SubscriberCompletion<? super T> sc = new SubscriberCompletion<T>(subscriber, this._dispatcher);
        this.pushOrSetResult(sc);
        return new Subscription<T>(){

            @Override
            public void cancel() {
                sc.cancel();
            }

            @Override
            public Publisher<T> getPublisher() {
                return PromiseImpl.this;
            }

            @Override
            public Subscriber<? super T> getSubscriber() {
                return subscriber;
            }
        };
    }

    @Override
    public Promise<T> onSuccess(Consumer<T> resultConsumer) {
        SuccessCompletion<T> c = new SuccessCompletion<T>(resultConsumer, this._dispatcher);
        this.pushOrSetResult(c);
        return ((Completion)c).getResultPromise();
    }

    @Override
    public Promise<T> onError(Consumer<Exception> errorConsumer) {
        ErrorCompletion c = new ErrorCompletion(errorConsumer, this._dispatcher);
        this.pushOrSetResult(c);
        return ((Completion)c).getResultPromise();
    }

    @Override
    public <U> Promise<U> thenCompose(Function<? super T, ? extends Promise<? extends U>> fn) {
        ComposeCompletion c = new ComposeCompletion(fn, this._dispatcher);
        this.pushOrSetResult(c);
        return ((Completion)c).getResultPromise();
    }

    @Override
    public <U> Promise<U> thenApply(Function<? super T, ? extends U> fn) {
        ApplyCompletion<T, U> c = new ApplyCompletion<T, U>(fn, this._dispatcher);
        this.pushOrSetResult(c);
        return ((Completion)c).getResultPromise();
    }

    @Override
    public <U, V> Promise<V> thenCombine(Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        CombineCompletion<T, U, V> cc = new CombineCompletion<T, U, V>(other, fn, this._dispatcher);
        cc.init();
        this.pushOrSetResult(cc);
        return cc.getResultPromise();
    }

    @Override
    public <U, V> Promise<V> thenCombineCompose(Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends Promise<? extends V>> fn) {
        CombineCompletion<T, U, Promise<V>> cc = new CombineCompletion<T, U, Promise<V>>(other, fn, this._dispatcher);
        cc.init();
        this.pushOrSetResult(cc);
        return cc.getResultPromise().thenCompose(promise -> promise);
    }

    @Override
    public Promise<PromiseResult<T>> materialize() {
        MaterializeCompletion c = new MaterializeCompletion(this._dispatcher);
        this.pushOrSetResult(c);
        return ((Completion)c).getResultPromise();
    }

    public boolean setResult(T value) {
        Result<T> result = new Result<T>(value);
        if (this._resultRef.compareAndSet(null, result)) {
            this._headRef.get().setResult(result);
            return true;
        }
        return false;
    }

    public boolean setError(Exception err) {
        Result result = new Result(err);
        if (this._resultRef.compareAndSet(null, result)) {
            this._headRef.get().setResult(result);
            return true;
        }
        return false;
    }

    public boolean isComplete() {
        return this._resultRef.get() != null;
    }

    void pushOrSetResult(Completion<T, ?> next) {
        boolean loop = true;
        while (loop) {
            Completion<T, ?> head = this._headRef.get();
            next.setNext(head);
            boolean bl = loop = !this._headRef.compareAndSet(head, next);
            Result<T> result = this._resultRef.get();
            if (result == null) continue;
            next.setResult(result);
            loop = false;
        }
    }

    private static class MaterializeCompletion<R>
    extends Completion<R, PromiseResult<R>> {
        private final PromiseImpl<PromiseResult<R>> _resultPromise = new PromiseImpl();

        MaterializeCompletion(Dispatcher dispatcher) {
            super(dispatcher);
        }

        @Override
        Promise<PromiseResult<R>> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            this._resultPromise.setResult(PromiseResult.fromResult(value));
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setResult(PromiseResult.fromException(err));
        }
    }

    private static class CombineCompletion<R, U, V>
    extends Completion<R, V>
    implements Subscriber<U> {
        private final Promise<U> _other;
        private final BiFunction<? super R, ? super U, ? extends V> _fn;
        private final PromiseImpl<V> _resultPromise = new PromiseImpl();
        private volatile Subscription<U> _subscription;
        private volatile Result<R> _result1;
        private volatile Result<U> _result2;
        private final AtomicBoolean _complete = new AtomicBoolean(false);

        CombineCompletion(Promise<? extends U> other, BiFunction<? super R, ? super U, ? extends V> fn, Dispatcher dispatcher) {
            super(dispatcher);
            Validate.notNull(other, (String)"other");
            Validate.notNull(fn, (String)"fn");
            this._other = other;
            this._fn = fn;
        }

        void init() {
            this._subscription = this._other.subscribe(this);
        }

        @Override
        public void onNext(U item) {
            this._result2 = new Result<U>(item);
            if (this._result1 != null && this._complete.compareAndSet(false, true)) {
                this.doComplete(this._result1.value, this._result2.value);
            }
        }

        @Override
        public void onComplete(boolean cancelled) {
        }

        @Override
        public void onError(Exception err) {
            this._resultPromise.setError(err);
        }

        @Override
        Promise<V> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            this._result1 = new Result<R>(value);
            if (this._result2 != null && this._complete.compareAndSet(false, true)) {
                this.doComplete(this._result1.value, this._result2.value);
            }
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
            this._subscription.cancel();
        }

        private void doComplete(R result1, U result2) {
            V result;
            try {
                result = this._fn.apply(result1, result2);
            }
            catch (Throwable t) {
                LOGGER.warn("Function '{}' failed.", this._fn, (Object)t);
                this._resultPromise.setError(Exceptions.wrap(t));
                return;
            }
            this._resultPromise.setResult(result);
        }
    }

    private static class ApplyCompletion<R, U>
    extends Completion<R, U> {
        private Function<? super R, ? extends U> _fn;
        private final PromiseImpl<U> _resultPromise = new PromiseImpl();

        ApplyCompletion(Function<? super R, ? extends U> fn, Dispatcher dispatcher) {
            super(dispatcher);
            Validate.notNull(fn, (String)"fn");
            this._fn = fn;
        }

        @Override
        Promise<U> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            U result;
            try {
                result = this._fn.apply(value);
            }
            catch (Throwable t) {
                LOGGER.warn("Function '{}' failed.", this._fn, (Object)t);
                this._resultPromise.setError(Exceptions.wrap(t));
                return;
            }
            this._resultPromise.setResult(result);
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
        }
    }

    private static class ComposeCompletion<R, U>
    extends Completion<R, U> {
        private final Function<? super R, ? extends Promise<? extends U>> _fn;
        private final PromiseImpl<U> _resultPromise = new PromiseImpl();

        ComposeCompletion(Function<? super R, ? extends Promise<? extends U>> fn, Dispatcher dispatcher) {
            super(dispatcher);
            Validate.notNull(fn, (String)"fn");
            this._fn = fn;
        }

        @Override
        Promise<U> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            Promise<U> then;
            try {
                then = this._fn.apply(value);
                Validate.notNull(then, (String)"then");
            }
            catch (Throwable t) {
                LOGGER.warn("Function '{}' failed.", this._fn, (Object)t);
                this._resultPromise.setError(Exceptions.wrap(t));
                return;
            }
            then.onError(thenExc -> this._resultPromise.setError((Exception)thenExc));
            then.onSuccess(thenResult -> this._resultPromise.setResult(thenResult));
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
        }
    }

    private static class ErrorCompletion<R>
    extends Completion<R, R> {
        private final Consumer<Exception> _consumer;
        private final PromiseImpl<R> _resultPromise = new PromiseImpl();

        ErrorCompletion(Consumer<Exception> consumer, Dispatcher dispatcher) {
            super(dispatcher);
            Validate.notNull(consumer, (String)"consumer");
            this._consumer = consumer;
        }

        @Override
        Promise<R> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            this._resultPromise.setResult(value);
        }

        @Override
        void complete(Exception err) {
            try {
                this._consumer.accept(err);
            }
            catch (Throwable t) {
                LOGGER.warn("Consumer '{}' failed.", this._consumer, (Object)t);
            }
            this._resultPromise.setError(err);
        }
    }

    private static class SuccessCompletion<R>
    extends Completion<R, R> {
        private final Consumer<R> _consumer;
        private final PromiseImpl<R> _resultPromise = new PromiseImpl();

        SuccessCompletion(Consumer<R> consumer, Dispatcher dispatcher) {
            super(dispatcher);
            Validate.notNull(consumer, (String)"consumer");
            this._consumer = consumer;
        }

        @Override
        Promise<R> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            try {
                this._consumer.accept(value);
            }
            catch (Throwable t) {
                LOGGER.warn("Consumer '{}' failed.", this._consumer, (Object)t);
            }
            this._resultPromise.setResult(value);
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
        }
    }

    private static class SubscriberCompletion<R>
    extends Completion<R, R> {
        private final Subscriber<? super R> _subscriber;
        private final PromiseImpl<R> _resultPromise = new PromiseImpl();

        SubscriberCompletion(Subscriber<? super R> subscriber, Dispatcher dispatcher) {
            super(dispatcher);
            this._subscriber = new SubscriberWrapper<R>(subscriber);
        }

        @Override
        Promise<R> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            try {
                this._subscriber.onNext(value);
                this._subscriber.onComplete(false);
            }
            catch (Throwable t) {
                LOGGER.warn("Subscriber '{}' failed.", this._subscriber, (Object)t);
            }
            this._resultPromise.setResult(value);
        }

        @Override
        void complete(Exception err) {
            try {
                this._subscriber.onError(err);
            }
            catch (Throwable t) {
                LOGGER.warn("Subscriber '{}' failed.", this._subscriber, (Object)t);
            }
            this._resultPromise.setError(err);
        }

        void cancel() {
            this._subscriber.onComplete(true);
        }
    }

    static abstract class Completion<R, S> {
        private final AtomicReference<Result<R>> _resultRef = new AtomicReference<Object>(null);
        private final Dispatcher _dispatcher;
        private final ThreadContext _context;
        volatile Completion<R, ?> _next = null;

        protected Completion(Dispatcher dispatcher) {
            this._dispatcher = dispatcher;
            this._context = ThreadContext.get();
        }

        void setNext(Completion<R, ?> next) {
            this._next = next;
        }

        void setResult(Result<R> result) {
            if (this._resultRef.compareAndSet(null, result)) {
                Completion<R, ?> next = this._next;
                this._next = null;
                if (next != null) {
                    next.setResult(result);
                }
                this._dispatcher.dispatch(() -> ThreadContext.setupContext(() -> result.complete(this), (ThreadContext)this._context));
            }
        }

        abstract Promise<S> getResultPromise();

        abstract void complete(R var1);

        abstract void complete(Exception var1);
    }

    private static final class Result<T> {
        final T value;
        final Exception err;

        Result(T value) {
            this.value = value;
            this.err = null;
        }

        Result(Exception err) {
            this.err = err;
            this.value = null;
        }

        void complete(Completion<T, ?> c) {
            if (this.err == null) {
                c.complete(this.value);
            } else {
                c.complete(this.err);
            }
        }
    }
}

