/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.PromiseResult;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.utilities.ExecutorUtils;
import com.vmware.srm.client.utilities.ThreadContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Promises {
    private static final Logger LOGGER = LoggerFactory.getLogger(Promises.class);

    public static Promise<ResultAccessor> all(Promise<?> ... promises) {
        if (promises.length == 0) {
            throw new IllegalArgumentException("At least one promise should be passed as argument");
        }
        return Promises.combinePromises(false, promises).thenApply(resultMap -> new ResultAccessor((Map)resultMap){
            final /* synthetic */ Map val$resultMap;
            {
                this.val$resultMap = map;
            }

            @Override
            public <T> T getResult(Promise<T> promise) {
                return (T)this.val$resultMap.get(promise);
            }
        });
    }

    public static Promise<PromiseResultAccessor> allWithException(Promise<?> ... promises) {
        if (promises.length == 0) {
            throw new IllegalArgumentException("At least one promise should be passed as argument");
        }
        return Promises.combinePromises(true, promises).thenApply(resultMap -> new PromiseResultAccessor((Map)resultMap){
            final /* synthetic */ Map val$resultMap;
            {
                this.val$resultMap = map;
            }

            @Override
            public <T> PromiseResult<T> getResult(Promise<T> promise) {
                return (PromiseResult)this.val$resultMap.get(promise);
            }
        });
    }

    private static Promise<Map<Promise<?>, Object>> combinePromises(boolean materialize, Promise<?> ... promises) {
        PromiseImpl initial;
        IdentityHashMap promiseMap = new IdentityHashMap(promises.length);
        Promise<Map<Promise<Object>, Object>> resultPromise = initial = new PromiseImpl();
        for (Promise<?> promise : promises) {
            promiseMap.put(promise, null);
            resultPromise = resultPromise.thenCombine(materialize ? promise.materialize() : promise, (result1, result2) -> {
                result1.put(promise, result2);
                return result1;
            });
        }
        initial.setResult(promiseMap);
        return resultPromise;
    }

    public static <T> Promise<T> resolve(T result) {
        PromiseImpl<T> promise = new PromiseImpl<T>();
        promise.setResult(result);
        return promise;
    }

    public static <T> Promise<T> reject(Exception e) {
        PromiseImpl promise = new PromiseImpl();
        LOGGER.debug("Promises.reject() with ", (Throwable)e);
        promise.setError(e);
        return promise;
    }

    public static <T> Promise<T> from(Callable<T> call) {
        return new ExecuteOnDemandPromise<T>(call);
    }

    @SafeVarargs
    public static <T> Promise<T> anyOf(Promise<T> ... promises) {
        if (promises.length == 0) {
            return Promises.reject(new IllegalArgumentException("promises"));
        }
        AtomicReference firstError = new AtomicReference();
        return Streams.from(Arrays.asList(promises)).flatMap(Promise::materialize).flatMap(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve(pr.getResult());
            }
            firstError.compareAndSet(null, pr.getError());
            return Streams.empty();
        }).next().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve(pr.getResult());
            }
            Exception cause = pr.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.reject((Exception)firstError.get());
            }
            return Promises.reject(cause);
        });
    }

    public static <T> Promise<T> createDelayedPromise(long delayMillis, T result) {
        PromiseImpl promise = new PromiseImpl();
        ExecutorUtils.getScheduledExecutor().schedule(() -> promise.setResult(result), delayMillis, TimeUnit.MILLISECONDS);
        return promise;
    }

    @SafeVarargs
    public static Promise<Boolean> or(Promise<Boolean> ... promises) {
        return Promises.or(Arrays.asList(promises));
    }

    public static Promise<Boolean> or(Collection<Promise<Boolean>> promises) {
        if (CollectionUtils.isEmpty(promises)) {
            return Promises.reject(new RuntimeException("'promises' is empty."));
        }
        return Streams.fromCollection(promises).filter(result -> result).next().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve(true);
            }
            Exception cause = pr.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.resolve(false);
            }
            return Promises.reject(pr.getError());
        });
    }

    @SafeVarargs
    public static Promise<Boolean> and(Promise<Boolean> ... promises) {
        return Promises.and(Arrays.asList(promises));
    }

    public static Promise<Boolean> and(Collection<Promise<Boolean>> promises) {
        if (CollectionUtils.isEmpty(promises)) {
            return Promises.reject(new RuntimeException("'promises' is empty."));
        }
        return Streams.fromCollection(promises).filter(result -> result == false).next().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve(false);
            }
            Exception cause = pr.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.resolve(true);
            }
            return Promises.reject(pr.getError());
        });
    }

    private static class ExecuteOnDemandPromise<T>
    extends PromiseImpl<T> {
        private final Callable<T> _call;
        private final AtomicBoolean _ran = new AtomicBoolean(false);

        ExecuteOnDemandPromise(Callable<T> call) {
            Validate.notNull(call, (String)"call");
            ThreadContext current = ThreadContext.get();
            this._call = () -> ThreadContext.setupContext((Callable)call, (ThreadContext)current);
        }

        @Override
        void pushOrSetResult(PromiseImpl.Completion<T, ?> next) {
            super.pushOrSetResult(next);
            if (this._ran.compareAndSet(false, true)) {
                ExecutorUtils.getExecutor().execute(() -> {
                    try {
                        T result = this._call.call();
                        this.setResult(result);
                    }
                    catch (Exception e) {
                        this.setError(e);
                    }
                });
            }
        }
    }

    public static interface PromiseResultAccessor {
        public <T> PromiseResult<T> getResult(Promise<T> var1);
    }

    public static interface ResultAccessor {
        public <T> T getResult(Promise<T> var1);
    }
}

