/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.Subscriber;
import com.vmware.srm.client.reactive.Subscription;
import com.vmware.srm.client.reactive.impl.FilterTransformStream;
import com.vmware.srm.client.reactive.impl.FlatMapTransformStream;
import com.vmware.srm.client.reactive.impl.MapTransformStream;
import com.vmware.srm.client.reactive.impl.MaterializeTransformStream;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.Validate;

abstract class TransformStream<T, U>
implements Stream<U> {
    protected final Publisher<T> _publisher;

    protected TransformStream(Publisher<T> publisher) {
        this._publisher = publisher;
    }

    @Override
    public Subscription<U> subscribe(final Subscriber<? super U> subscriber) {
        final Subscription<T> inner = this._publisher.subscribe(new SubscriberHelper(subscriber));
        return new Subscription<U>(){

            @Override
            public Publisher<U> getPublisher() {
                return TransformStream.this;
            }

            @Override
            public Subscriber<? super U> getSubscriber() {
                return subscriber;
            }

            @Override
            public void cancel() {
                inner.cancel();
            }
        };
    }

    protected abstract void processNext(T var1, Subscriber<? super U> var2);

    protected void processError(Exception exc, Subscriber<? super U> subscriber) {
        subscriber.onError(exc);
    }

    protected void processComplete(boolean cancelled, Subscriber<? super U> subscriber) {
        subscriber.onComplete(cancelled);
    }

    @Override
    public Stream<U> filter(Predicate<? super U> predicate) {
        return new FilterTransformStream<U>(this, predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super U, ? extends R> mapper) {
        return new MapTransformStream<U, R>(this, mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super U, ? extends Publisher<? extends R>> mapper) {
        return new FlatMapTransformStream(this, mapper);
    }

    @Override
    public <R> Promise<R> reduce(final R identity, final BiFunction<R, ? super U, R> accumulator) {
        final PromiseImpl result = new PromiseImpl();
        this.subscribe(new Subscriber<U>(){
            R _current;
            {
                this._current = identity;
            }

            @Override
            public void onNext(U item) {
                this._current = accumulator.apply(this._current, item);
            }

            @Override
            public void onComplete(boolean cancelled) {
                result.setResult(this._current);
            }

            @Override
            public void onError(Exception err) {
                result.setError(err);
                this._current = null;
            }
        });
        return result;
    }

    @Override
    public Promise<U> next() {
        final AtomicReference<Object> subRef = new AtomicReference<Object>(null);
        final PromiseImpl result = new PromiseImpl<U>(){

            @Override
            public boolean setResult(U value) {
                return this.unsubscribe(super.setResult(value));
            }

            @Override
            public boolean setError(Exception err) {
                return this.unsubscribe(super.setError(err));
            }

            boolean unsubscribe(boolean result) {
                Subscription sub = subRef.getAndSet(null);
                if (sub != null) {
                    sub.cancel();
                }
                return result;
            }
        };
        subRef.set(this.subscribe(new Subscriber<U>(){

            @Override
            public void onNext(U item) {
                result.setResult(item);
            }

            @Override
            public void onComplete(boolean cancelled) {
                result.setError(new Stream.StreamCompleteException());
            }

            @Override
            public void onError(Exception err) {
                result.setError(err);
            }
        }));
        return result;
    }

    @Override
    public Stream<Stream.StreamEvent<U>> materialize() {
        return new MaterializeTransformStream(this);
    }

    private final class SubscriberHelper
    implements Subscriber<T> {
        private final Subscriber<? super U> _delegate;

        SubscriberHelper(Subscriber<? super U> delegate) {
            Validate.notNull(delegate);
            this._delegate = delegate;
        }

        @Override
        public void onNext(T item) {
            TransformStream.this.processNext(item, this._delegate);
        }

        @Override
        public void onComplete(boolean cancelled) {
            TransformStream.this.processComplete(cancelled, this._delegate);
        }

        @Override
        public void onError(Exception err) {
            TransformStream.this.processError(err, this._delegate);
        }
    }
}

