/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.HttpResponseAccessor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExecutionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient SecurityContext securityContext;
    private final transient ApplicationData applicationData;
    private final transient RuntimeData runtimeData;
    public static final ExecutionContext EMPTY = new ExecutionContext();

    public ExecutionContext() {
        this(null, null, null);
    }

    public ExecutionContext(SecurityContext securityContext) {
        this(null, securityContext, null);
    }

    public ExecutionContext(ApplicationData wireData, SecurityContext securityContext) {
        this(wireData, securityContext, null);
    }

    public ExecutionContext(ApplicationData wireData, SecurityContext securityContext, RuntimeData runtimeData) {
        this.applicationData = wireData;
        this.securityContext = securityContext;
        this.runtimeData = runtimeData;
    }

    public ApplicationData retrieveApplicationData() {
        return this.applicationData;
    }

    public SecurityContext retrieveSecurityContext() {
        return this.securityContext;
    }

    public RuntimeData retrieveRuntimeData() {
        return this.runtimeData;
    }

    public static class Builder {
        private ApplicationData applicationData;
        private SecurityContext securityContext;
        private Integer readTimeout;
        private HttpResponseAccessor responseAccessor;

        public Builder setApplicationData(ApplicationData applicationData) {
            this.applicationData = applicationData;
            return this;
        }

        public Builder setSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public Builder setReadTimeout(Integer readTimeout) {
            Builder.assertNonNegative(readTimeout);
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setResponseAccessor(HttpResponseAccessor responseAccessor) {
            this.responseAccessor = responseAccessor;
            return this;
        }

        private static void assertNonNegative(Integer value) {
            if (value != null && value < 0) {
                throw new IllegalArgumentException("Non-negative value or null expected");
            }
        }

        public ExecutionContext build() {
            return new ExecutionContext(this.applicationData, this.securityContext, this.getRuntimeData());
        }

        private RuntimeData getRuntimeData() {
            return new RuntimeData(this.readTimeout, this.responseAccessor);
        }
    }

    public static class RuntimeData {
        private final Integer readTimeout;
        private final HttpResponseAccessor responseAccessor;

        private RuntimeData(Integer readTimeout, HttpResponseAccessor responseAccessor) {
            this.readTimeout = readTimeout;
            this.responseAccessor = responseAccessor;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public HttpResponseAccessor getResponseAccessor() {
            return this.responseAccessor;
        }
    }

    public static interface SecurityContext {
        public static final String AUTHENTICATION_SCHEME_ID = "authn_scheme_id";
        public static final String AUTHENTICATION_DATA_ID = "authn_data_id";

        public Object getProperty(String var1);

        public Map<String, Object> getAllProperties();
    }

    public static class ApplicationData {
        public static final String USER_AGENT_KEY = "$userAgent";
        public static final String TIMEZONE_KEY = "timezone";
        public static final String ACCEPT_LANGUAGE_KEY = "accept-language";
        public static final String FORMAT_LOCALE_KEY = "format-locale";
        private final Map<String, String> wireData;

        public ApplicationData() {
            this.wireData = Collections.emptyMap();
        }

        public ApplicationData(Map<String, String> data) {
            this.wireData = new HashMap<String, String>(data.size(), 1.0f);
            this.wireData.putAll(data);
        }

        public ApplicationData(String key, String value) {
            this.wireData = Collections.singletonMap(key, value);
        }

        private ApplicationData(ApplicationData source, Map<String, String> data) {
            this.wireData = new HashMap<String, String>(source.wireData.size() + data.size(), 1.0f);
            this.wireData.putAll(source.wireData);
            this.wireData.putAll(data);
        }

        private ApplicationData(ApplicationData source, String key, String value) {
            this.wireData = new HashMap<String, String>(source.wireData.size() + 1, 1.0f);
            this.wireData.putAll(source.wireData);
            this.wireData.put(key, value);
        }

        public String getProperty(String key) {
            return this.wireData.get(key);
        }

        public Map<String, String> getAllProperties() {
            return Collections.unmodifiableMap(this.wireData);
        }

        public static ApplicationData merge(ApplicationData source, Map<String, String> data) {
            if (source == null) {
                return new ApplicationData(data);
            }
            return new ApplicationData(source, data);
        }

        public static ApplicationData merge(ApplicationData source, String key, String value) {
            if (source == null || source.wireData.size() == 0) {
                return new ApplicationData(key, value);
            }
            return new ApplicationData(source, key, value);
        }
    }
}

