/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.core.abort;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortListener;
import com.vmware.vapi.internal.util.Validate;
import java.util.ArrayList;
import java.util.List;

public class AbortHandleImpl
implements AbortHandle {
    private boolean isAborted = false;
    private final List<AbortListener> listeners = new ArrayList<AbortListener>();

    @Override
    public synchronized void addAbortListener(AbortListener listener) {
        Validate.notNull(listener);
        if (this.isAborted()) {
            return;
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        AbortHandleImpl abortHandleImpl = this;
        synchronized (abortHandleImpl) {
            if (this.isAborted) {
                return;
            }
            this.isAborted = true;
        }
        for (AbortListener listener : this.listeners) {
            listener.onAbort();
        }
    }

    @Override
    public synchronized boolean isAborted() {
        return this.isAborted;
    }

    protected List<AbortListener> getListeners() {
        return this.listeners;
    }
}

