/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.diagnostics;

public class DiagnosticsKey {
    private final String componentId;
    private String[] counters = null;
    private String diagnosticsKey;

    public DiagnosticsKey(String componentId) {
        this(componentId, new String[0]);
    }

    public DiagnosticsKey(String componentId, String[] counters) {
        this.componentId = componentId;
        this.counters = counters;
        this.initializeKey();
    }

    private void initializeKey() {
        this.diagnosticsKey = this.componentId;
        for (String componentCategory : this.counters) {
            this.diagnosticsKey = this.diagnosticsKey + ":" + componentCategory;
        }
    }

    public String[] getComponentCounters() {
        return this.counters;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiagnosticsKey)) {
            return false;
        }
        return this.diagnosticsKey.equals(((DiagnosticsKey)obj).diagnosticsKey);
    }

    public int hashCode() {
        return this.diagnosticsKey.hashCode();
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String toString() {
        return this.diagnosticsKey;
    }
}

