/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.protocol.client.rest.BodyConverter;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.protocol.common.DataValueBuilder;
import com.vmware.vapi.internal.protocol.common.DirectDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class DefaultBodyConverter
implements BodyConverter {
    private final DirectDeserializer deserializer;

    public DefaultBodyConverter(DirectDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public DataValue getResult(String serviceId, String operationId, HttpResponse response) {
        DataValueBuilder resultBuilder = new DataValueBuilder();
        ByteArrayInputStream stream = null;
        byte[] rawResponse = response.getBody();
        if (rawResponse == null || rawResponse.length == 0) {
            return VoidValue.getInstance();
        }
        stream = new ByteArrayInputStream(rawResponse);
        try {
            this.deserializer.deserialize(resultBuilder, stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resultBuilder.getResult();
    }
}

