/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.protocol.client.rest.DefaultRequestBuilder;
import com.vmware.vapi.internal.protocol.client.rest.OperationRestMetadata;
import com.vmware.vapi.internal.protocol.client.rest.OperationRestMetadataProvider;
import com.vmware.vapi.internal.protocol.client.rest.RequestBuilder;
import com.vmware.vapi.internal.protocol.client.rest.RequestBuilderFactory;
import com.vmware.vapi.internal.protocol.client.rest.RestMetadataBasedHttpRequestBuilder;
import com.vmware.vapi.internal.protocol.common.DirectSerializer;
import com.vmware.vapi.internal.protocol.common.SerializerConfig;
import com.vmware.vapi.internal.protocol.common.http.UrlUtil;
import com.vmware.vapi.internal.util.Validate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RestRequestBuilderFactory
implements RequestBuilderFactory {
    private final DirectSerializer serializer;
    private final OperationRestMetadataProvider restMetadataProvider;
    private final UrlUtil urlUtil;
    protected final String baseUrl;

    public RestRequestBuilderFactory(String baseUrl, DirectSerializer serializer, OperationRestMetadataProvider restMetadataProvider, UrlUtil urlUtil) {
        Validate.notNull(baseUrl);
        Validate.notNull(serializer);
        Validate.notNull(restMetadataProvider);
        Validate.notNull(urlUtil);
        this.baseUrl = baseUrl;
        this.serializer = serializer;
        this.restMetadataProvider = restMetadataProvider;
        this.urlUtil = urlUtil;
    }

    @Override
    public RequestBuilder createRequestBuilder(String serviceId, String operationId) {
        OperationRestMetadata restMetadata = this.restMetadataProvider.getRestMetadata(serviceId, operationId);
        try {
            return new RestRequestBuilder(restMetadata, new RestMetadataBasedHttpRequestBuilder(restMetadata, this.urlUtil));
        }
        catch (Exception e) {
            return null;
        }
    }

    private final class RestRequestBuilder
    extends DefaultRequestBuilder {
        public RestRequestBuilder(OperationRestMetadata operationMetadata, RestMetadataBasedHttpRequestBuilder httpRequestBuilder) {
            super(httpRequestBuilder, operationMetadata, RestRequestBuilderFactory.this.baseUrl);
        }

        @Override
        public byte[] buildBody(StructValue input) {
            DataValue requestBodyValue = this.getHttpRequestBuilder().getRequestBodyValue(input);
            if (requestBodyValue == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            SerializerConfig writerConfig = new SerializerConfig(false, false);
            try {
                RestRequestBuilderFactory.this.serializer.serialize(requestBodyValue, outputStream, writerConfig);
                return outputStream.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

