/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.VersionUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRequestConfigurationMerger;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpUtil.class);
    public static final String VAPI_USER_AGENT = VersionUtil.getUserAgent();

    private ApacheHttpUtil() {
    }

    public static void validateHttpResponse(HttpResponse httpResponse, String requestContentType) {
        boolean expectedContentType;
        Validate.notNull(httpResponse);
        HttpEntity entity = httpResponse.getEntity();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (300 <= statusCode && statusCode <= 399) {
            ApacheHttpUtil.silentClose(entity);
            throw new TransportProtocolException(String.format("HTTP redirect response with status code %d (enable debug logging for details)", statusCode));
        }
        if (entity == null) {
            throw new TransportProtocolException(String.format("HTTP response with status code %d and no content (enable debug logging for details)", statusCode));
        }
        String contentType = null;
        if (entity.getContentType() != null) {
            contentType = ApacheHttpUtil.stripContentTypeParams(entity.getContentType().getValue());
        }
        if (400 <= statusCode && statusCode <= 599) {
            String text = ApacheHttpUtil.readResponseBodyAndClose(entity, contentType);
            if (text != null) {
                throw new TransportProtocolException(String.format("HTTP response with status code %d (enable debug logging for details): %s", statusCode, text));
            }
            throw new TransportProtocolException(String.format("HTTP response with status code %d (enable debug logging for details)", statusCode));
        }
        if (contentType == null) {
            ApacheHttpUtil.silentClose(entity);
            throw new TransportProtocolException(String.format("HTTP response with status code %d and no Content-Type header (enable debug logging for details)", statusCode));
        }
        boolean bl = expectedContentType = requestContentType.equals(contentType) || "application/vnd.vmware.vapi.framed".equals(contentType);
        if (!expectedContentType) {
            String text = ApacheHttpUtil.readResponseBodyAndClose(entity, contentType);
            if (text != null) {
                throw new TransportProtocolException(String.format("HTTP response with status code %d has unexpected content-type '%s' (enable debug logging for details): %s", statusCode, contentType, text));
            }
            throw new TransportProtocolException(String.format("HTTP response with status code %d has unexpected content-type '%s' (enable debug logging for details)", statusCode, contentType));
        }
    }

    static String stripContentTypeParams(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semiColonIndex = contentType.indexOf(59);
        if (semiColonIndex >= 0) {
            contentType = contentType.substring(0, semiColonIndex);
        }
        return contentType.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readResponseBodyAndClose(HttpEntity entity, String contentType) {
        try (InputStream responseBody = entity.getContent();){
            if (contentType == null) {
                String string = null;
                return string;
            }
            if (!contentType.contains("text")) {
                String string = null;
                return string;
            }
            String string = new String(IoUtil.readAll(responseBody), "UTF-8");
            return string;
        }
        catch (IOException ex) {
            return "<IOException while reading response body>";
        }
    }

    private static void silentClose(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            IoUtil.silentClose(entity.getContent());
        }
        catch (IOException ex) {
            logger.debug("Error while closing HTTP response body stream", (Throwable)ex);
        }
    }

    static RequestConfig createDefaultRequestConfig(HttpConfiguration httpConfig) {
        return RequestConfig.custom().setSocketTimeout(httpConfig.getSoTimeout()).setConnectTimeout(httpConfig.getConnectTimeout()).build();
    }

    static HttpClientContext createHttpContext(ExecutionContext executionContext, ApacheClientRequestConfigurationMerger configMerger) {
        ExecutionContext.RuntimeData runtimeData = executionContext == null ? null : executionContext.retrieveRuntimeData();
        Integer readTimeout = runtimeData == null ? null : runtimeData.getReadTimeout();
        return ApacheHttpUtil.createHttpContext(readTimeout, configMerger);
    }

    static HttpClientContext createHttpContext(Integer readTimeout, ApacheClientRequestConfigurationMerger configMerger) {
        RequestConfig config = configMerger.mergeWithDefaultConfig(readTimeout);
        HttpClientContext httpContext = new HttpClientContext();
        httpContext.setRequestConfig(config);
        return httpContext;
    }
}

