/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortListener;
import com.vmware.vapi.internal.core.abort.RequestAbortedException;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.util.Locale;
import java.util.Map;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger logger = LoggerFactory.getLogger(Util.class);

    public static boolean checkRequestAborted(AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb) {
        if (abortHandle != null && abortHandle.isAborted()) {
            cb.failed(new RequestAbortedException("Request aborted, aborting execution."));
            return true;
        }
        return false;
    }

    public static void registerAbortListerner(final CorrelatingClient.ResponseCallback cb, final HttpPost post, AbortHandle abortHandle) {
        Validate.notNull(cb);
        Validate.notNull(post);
        if (abortHandle == null) {
            return;
        }
        abortHandle.addAbortListener(new AbortListener(){

            @Override
            public void onAbort() {
                if (logger.isDebugEnabled()) {
                    logger.debug("Request aborted, aborting HTTP post execution.");
                }
                cb.failed(new RequestAbortedException("Http request aborted."));
                post.abort();
            }
        });
    }

    public static void addHeaders(HttpPost post, String requestContentType, HttpConfiguration.Protocol protocol, String serviceId, String operationId, ExecutionContext executionContext) {
        Validate.notNull(post);
        Validate.notNull(serviceId);
        Validate.notNull(operationId);
        Validate.notNull(executionContext);
        Util.addJsonRpcHeaders(post, requestContentType);
        if (protocol == HttpConfiguration.Protocol.VAPI_JSON_RPC_1_1) {
            Util.addJsonRpc11ExtraHeaders(post, serviceId, operationId, executionContext);
        }
    }

    private static void addJsonRpcHeaders(HttpPost post, String requestContentType) {
        post.setHeader("Content-Type", requestContentType);
        post.setHeader("Accept", "application/vnd.vmware.vapi.framed," + requestContentType);
    }

    private static void addJsonRpc11ExtraHeaders(HttpPost post, String serviceId, String operationId, ExecutionContext executionContext) {
        Object sessionId;
        ExecutionContext.SecurityContext securityContext;
        post.setHeader("vapi-service", serviceId);
        post.setHeader("vapi-operation", operationId);
        ExecutionContext.ApplicationData applicationData = executionContext.retrieveApplicationData();
        if (applicationData != null) {
            Map<String, String> wireData = applicationData.getAllProperties();
            for (Map.Entry<String, String> appEntry : wireData.entrySet()) {
                String value = appEntry.getValue();
                if (value == null) continue;
                String headerName = appEntry.getKey();
                if (!"accept-language".equals(headerName)) {
                    headerName = "vapi-ctx-" + headerName.toLowerCase(Locale.ENGLISH);
                }
                post.setHeader(headerName, value);
            }
        }
        if ((securityContext = executionContext.retrieveSecurityContext()) != null && (sessionId = securityContext.getProperty("sessionId")) != null) {
            post.setHeader("vmware-api-session-id", String.valueOf((char[])sessionId));
        }
    }
}

