/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.convert.ConverterException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rfc3339DateTimeConverter {
    private static final char TIME_OFFSET_Z = 'Z';
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("GMT+00:00");
    private static final int[] POWERS_OF_TEN = new int[]{1, 10, 100};
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    private static final String DATETIME_PATTERN_STRING = "(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?([Z,\\+,\\-])(\\d{2}:\\d{2})?";
    private static final Pattern DATETIME_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?([Z,\\+,\\-])(\\d{2}:\\d{2})?");
    private static final String DATETIME_FORMATTER_STRING = "%1$tY-%1$tm-%1$tdT%1$tH:%1$tM:%1$tS.%1$tLZ";

    public GregorianCalendar fromStringValue(String datetime) {
        Matcher m = DATETIME_PATTERN.matcher(datetime);
        if (!m.matches()) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.invalid.format", datetime, DATETIME_PATTERN_STRING));
        }
        int year = Integer.parseInt(m.group(1));
        int month = Integer.parseInt(m.group(2));
        int day = Integer.parseInt(m.group(3));
        int hour = Integer.parseInt(m.group(4));
        int minute = Integer.parseInt(m.group(5));
        int second = Integer.parseInt(m.group(6));
        int millisecond = this.parseFraction(m.group(7));
        char tzSign = m.group(8).charAt(0);
        String tzHourMinute = m.group(9);
        if (year <= 0) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.year.bc", datetime));
        }
        if (month < 1 || month > 12) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.month.invalid", datetime));
        }
        if (day < 1 || day > 31) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.day.invalid", datetime));
        }
        if (hour > 23) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.hour.invalid", datetime));
        }
        if (minute > 59) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.minute.invalid", datetime));
        }
        if (second > 60) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.second.invalid", datetime));
        }
        if ('Z' == tzSign) {
            if (tzHourMinute != null) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.timezone.invalid", datetime));
            }
        } else {
            if (tzHourMinute == null) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.timezone.invalid", datetime));
            }
            if (Integer.parseInt(tzHourMinute.substring(0, 2)) > 23) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.timezone.hour.invalid", datetime));
            }
            if (Integer.parseInt(tzHourMinute.substring(3)) > 59) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.timezone.minute.invalid", datetime));
            }
        }
        TimeZone timeZone = this.buildTimeZone(tzSign, tzHourMinute);
        if (second == 60) {
            if (this.isLeapSecondAllowed(year, month, day, hour, minute, timeZone)) {
                second = 59;
                millisecond = 999;
            } else {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.second.leap.invalid", datetime));
            }
        }
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.clear();
            calendar.setLenient(false);
            calendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
            calendar.setTimeZone(timeZone);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            calendar.set(14, millisecond);
            calendar.getTimeInMillis();
            return Rfc3339DateTimeConverter.toUtcCalendar(calendar);
        }
        catch (RuntimeException ex) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.invalid.time", datetime, ex.getMessage()), (Throwable)ex);
        }
    }

    private boolean isLeapSecondAllowed(int year, int month, int day, int hour, int minute, TimeZone timeZone) {
        if (year < 1972) {
            return false;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
        calendar.setTimeZone(timeZone);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.getTimeInMillis();
        GregorianCalendar utcCal = Rfc3339DateTimeConverter.toUtcCalendar(calendar);
        int utcHour = utcCal.get(11);
        int utcMinute = utcCal.get(12);
        return utcHour == 23 && utcMinute == 59 && this.isLastDayOfMonth(utcCal);
    }

    private boolean isLastDayOfMonth(Calendar cal) {
        int month = cal.get(2);
        cal.add(5, 1);
        return month != cal.get(2);
    }

    public String toStringValue(Calendar calendar) {
        GregorianCalendar utcCalendar = Rfc3339DateTimeConverter.toUtcCalendar(calendar);
        if (Rfc3339DateTimeConverter.isYearBC(utcCalendar)) {
            throw new CoreException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.serialize.year.bc", calendar.toString()));
        }
        if (utcCalendar.get(1) > 9999) {
            throw new CoreException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.serialize.year.too.big", calendar.toString()));
        }
        return String.format(DATETIME_FORMATTER_STRING, utcCalendar);
    }

    private TimeZone buildTimeZone(char tzSign, String tzHourMinute) {
        if ('Z' == tzSign) {
            return UTC_ZONE;
        }
        StringBuilder sb = new StringBuilder(9);
        sb.append("GMT").append(tzSign).append(tzHourMinute);
        return TimeZone.getTimeZone(sb.toString());
    }

    private int parseFraction(String strFraction) {
        if (strFraction == null) {
            return 0;
        }
        int endIndex = strFraction.length() < 4 ? strFraction.length() : 4;
        int significand = Integer.parseInt(strFraction.substring(1, endIndex));
        return significand * POWERS_OF_TEN[4 - endIndex];
    }

    private static boolean isYearBC(GregorianCalendar c) {
        return c.get(0) == 0;
    }

    private static GregorianCalendar toUtcCalendar(Calendar calendar) {
        GregorianCalendar utcCalendar = new GregorianCalendar();
        utcCalendar.clear();
        utcCalendar.setLenient(false);
        utcCalendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
        utcCalendar.setTimeZone(UTC_ZONE);
        utcCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return utcCalendar;
    }
}

