/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtil {
    private static final Logger logger = LoggerFactory.getLogger(IoUtil.class);
    private static final int COPY_BUFFER_SIZE = 1024;

    private IoUtil() {
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = src.read(buffer)) >= 0) {
            dst.write(buffer, 0, len);
        }
    }

    public static byte[] readAll(InputStream inp) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtil.copy(inp, out);
        return out.toByteArray();
    }

    public static void silentClose(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException io) {
            logger.debug("Error while closing resource", (Throwable)io);
        }
    }
}

