/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.util.Validate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public final class SessionSecurityContext
implements ExecutionContext.SecurityContext {
    public static final String SESSION_ID_KEY = "sessionId";
    private final char[] sessionId;

    public SessionSecurityContext(char[] sessionId) {
        Validate.notNull(sessionId, "'sessionId' must not be null");
        Validate.isTrue(sessionId.length > 0, "'sessionId' must not be empty");
        this.sessionId = Arrays.copyOf(sessionId, sessionId.length);
    }

    @Override
    public Object getProperty(String key) {
        if (SESSION_ID_KEY.equals(key)) {
            return this.sessionId;
        }
        if ("authn_scheme_id".equals(key)) {
            return "com.vmware.vapi.std.security.session_id";
        }
        return null;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        return Collections.singletonMap(SESSION_ID_KEY, this.sessionId);
    }

    public char[] getSessionId() {
        return Arrays.copyOf(this.sessionId, this.sessionId.length);
    }

    public static SessionSecurityContext newInstance(ExecutionContext.SecurityContext context) {
        char[] sessionId;
        Validate.notNull(context);
        String sessionIdStr = SessionSecurityContext.getAsString(context.getProperty(SESSION_ID_KEY));
        char[] cArray = sessionId = sessionIdStr == null ? SessionSecurityContext.getAsCharArr(context.getProperty(SESSION_ID_KEY)) : sessionIdStr.toCharArray();
        if (sessionId != null) {
            return new SessionSecurityContext(sessionId);
        }
        return null;
    }

    private static String getAsString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static char[] getAsCharArr(Object value) {
        if (value instanceof char[]) {
            return (char[])value;
        }
        return null;
    }
}

