/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.af.interop;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.vmware.af.DomainInfo;
import com.vmware.af.PasswordCredential;
import com.vmware.af.VmAfClientNativeException;
import com.vmware.af.interop.NativeAdapter;
import com.vmware.af.interop.VmAfClientAdapterErrorHandler;

public class VmAfClientAdapter
extends NativeAdapter {
    private Pointer _vmAfHeartbeatHandle;

    public static int getStatus(String hostname) {
        IntByReference pStatus = new IntByReference(0);
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetStatusA(hostname, pStatus);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
        return pStatus.getValue();
    }

    public static void vecsForceRefresh() {
        String host = "localhost";
        int errCode = VmAfClientAdapter.callRefresh("localhost");
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    private static int callRefresh(String host) {
        return VmAfClientLibrary.INSTANCE.VmAfdTriggerRootCertsRefresh(host, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainName(String hostname) {
        PointerByReference ppszDomain = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetDomainNameA(hostname, ppszDomain);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszDomain.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszDomain.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static void setDomainName(String hostname, String domain) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetDomainNameA(hostname, domain);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainState(String hostname) {
        PointerByReference pDomainState = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetDomainStateA(hostname, pDomainState);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = pDomainState.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = pDomainState.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLDU(String hostname) {
        PointerByReference ppszLDU = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetLDUA(hostname, ppszLDU);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszLDU.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszLDU.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static void setLDU(String hostname, String ldu) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetLDUA(hostname, ldu);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDCName(String hostname) {
        PointerByReference ppszDCName = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetDCNameA(hostname, ppszDCName);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszDCName.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszDCName.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDCNameEx(String hostname, String domainId) {
        PointerByReference ppszDCName = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetDCNameExA(hostname, domainId, ppszDCName);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszDCName.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszDCName.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainId(String hostname) {
        PointerByReference ppszDomainId = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetDomainIdA(hostname, ppszDomainId);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszDomainId.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszDomainId.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static void setDCName(String hostname, String dc) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetDCNameA(hostname, dc);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static int getRHTTPProxyPort(String hostname) {
        IntByReference pdwPort = new IntByReference(0);
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetRHTTPProxyPortA(hostname, pdwPort);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
        return pdwPort.getValue();
    }

    public static void setRHTTPProxyPort(String hostname, int port) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetRHTTPProxyPortA(hostname, port);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static void setDCPort(String hostname, int port) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetDCPortA(hostname, port);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCMLocation(String hostname) {
        PointerByReference ppszCMLocation = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetCMLocationA(hostname, ppszCMLocation);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszCMLocation.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszCMLocation.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLSLocation(String hostname) {
        PointerByReference ppszLSLocation = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetLSLocationA(hostname, ppszLSLocation);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszLSLocation.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszLSLocation.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPNID(String hostname) {
        PointerByReference ppszPNID = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetPNIDA(hostname, ppszPNID);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszPNID.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszPNID.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPNIDUrl(String hostname) {
        PointerByReference ppszPNID = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetPNIDForUrlA(hostname, ppszPNID);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszPNID.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszPNID.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static void setPNID(String hostname, String PNID) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetPNIDA(hostname, PNID);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMachineCert(String hostname) {
        PointerByReference ppszCertificate = new PointerByReference();
        PointerByReference ppszPrivateKey = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetSSLCertificate(hostname, ppszCertificate, ppszPrivateKey);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszCertificate.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszCertificate.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
            if ((val = ppszPrivateKey.getValue()) != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMachinePrivateKey(String hostname) {
        PointerByReference ppszCertificate = new PointerByReference();
        PointerByReference ppszPrivateKey = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetSSLCertificate(hostname, ppszCertificate, ppszPrivateKey);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszPrivateKey.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszCertificate.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
            if ((val = ppszPrivateKey.getValue()) != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static void setMachineCert(String hostname, String certificate, String privatekey) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetSSLCertificate(hostname, certificate, privatekey);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static void promoteVmDir(String pszServerName, String pszDomainName, String pszUserName, String pszPassword, String pszSiteName, String pszPartnerName) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdPromoteVmDirA(pszServerName, pszDomainName, pszUserName, pszPassword, pszSiteName, pszPartnerName);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static void demoteVmDir(String pszServerName, String pszUserName, String pszPassword) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdDemoteVmDirA(pszServerName, pszUserName, pszPassword);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static void joinVmDir(String pszServerName, String pszUserName, String pszPassword, String pszMachineName, String pszDomainName, String pszOrgUnit) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdJoinVmDirA(pszServerName, pszUserName, pszPassword, pszMachineName, pszDomainName, pszOrgUnit);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static void leaveVmDir(String pszServerName, String pszUserName, String pszPassword) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdLeaveVmDirA(pszServerName, pszUserName, pszPassword);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    public static void joinAD(String pszServerName, String pszUserName, String pszPassword, String pszDomainName, String pszOrgUnit) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdJoinADA(pszServerName, pszUserName, pszPassword, pszDomainName, pszOrgUnit);
        VmAfClientAdapterErrorHandler.handleErrorCode(errCode);
    }

    public static void leaveAD(String pszServerName, String pszUserName, String pszPassword) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdLeaveADA(pszServerName, pszUserName, pszPassword);
        VmAfClientAdapterErrorHandler.handleErrorCode(errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainInfo queryAD(String pszServerName) {
        PointerByReference ppszComputer = new PointerByReference();
        PointerByReference ppszDomain = new PointerByReference();
        PointerByReference ppszDistinguishedName = new PointerByReference();
        PointerByReference ppszNetbiosName = new PointerByReference();
        Pointer ptr = null;
        String pszComputer = null;
        String pszDomain = null;
        String pszDistinguishedName = null;
        String pszNetbiosName = null;
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdQueryADA(pszServerName, ppszComputer, ppszDomain, ppszDistinguishedName, ppszNetbiosName);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            if (ppszComputer != null && (ptr = ppszComputer.getValue()) != Pointer.NULL && ptr != null) {
                pszComputer = ptr.getString(0L);
            }
            if (ppszDomain != null && (ptr = ppszDomain.getValue()) != Pointer.NULL && ptr != null) {
                pszDomain = ptr.getString(0L);
            }
            if (ppszDistinguishedName != null && (ptr = ppszDistinguishedName.getValue()) != Pointer.NULL && ptr != null) {
                pszDistinguishedName = ptr.getString(0L);
            }
            if (ppszNetbiosName != null && (ptr = ppszNetbiosName.getValue()) != Pointer.NULL && ptr != null) {
                pszNetbiosName = ptr.getString(0L);
            }
            DomainInfo domainInfo = new DomainInfo(pszComputer, pszDomain, pszDistinguishedName, pszNetbiosName);
            return domainInfo;
        }
        finally {
            Pointer val = ppszComputer.getValue();
            if (val != Pointer.NULL && val != null) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
            if ((val = ppszDomain.getValue()) != Pointer.NULL && val != null) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
            if ((val = ppszDistinguishedName.getValue()) != Pointer.NULL && val != null) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
            if ((val = ppszNetbiosName.getValue()) != Pointer.NULL && val != null) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMachineID(String hostname) {
        PointerByReference ppszMachineId = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetMachineIDA(hostname, ppszMachineId);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszMachineId.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszMachineId.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static void setMachineID(String hostname, String machineId) {
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdSetMachineIDA(hostname, machineId);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordCredential getMachineAccountCredentials() {
        PointerByReference ppszAccount = new PointerByReference();
        PointerByReference ppszPassword = new PointerByReference();
        try {
            int code = VmAfClientLibrary.INSTANCE.VmAfdGetMachineAccountInfoA("localhost", ppszAccount, ppszPassword);
            if (code != 0) {
                throw new VmAfClientNativeException(code);
            }
            PasswordCredential passwordCredential = new PasswordCredential(ppszAccount.getValue().getString(0L), ppszPassword.getValue().getString(0L));
            return passwordCredential;
        }
        finally {
            Pointer pszPassword;
            Pointer pszAccount = ppszAccount.getValue();
            if (pszAccount != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(pszAccount);
            }
            if ((pszPassword = ppszPassword.getValue()) != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(pszPassword);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSiteGUID(String hostname) {
        PointerByReference ppszSiteGUID = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetSiteGUIDA(hostname, ppszSiteGUID);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszSiteGUID.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszSiteGUID.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static Object startHeartbeat(String ServiceName, int Port) {
        PointerByReference ppHeartbeatHandle = new PointerByReference();
        int errCode = VmAfClientLibrary.INSTANCE.VmAfdStartHeartbeatA(ServiceName, Port, ppHeartbeatHandle);
        if (errCode != 0) {
            throw new VmAfClientNativeException(errCode);
        }
        return ppHeartbeatHandle.getValue();
    }

    public static void stopHeartbeat(Object pHeartbeatHandle) {
        Pointer HeartbeatPointer = null;
        if (pHeartbeatHandle != null && pHeartbeatHandle instanceof Pointer) {
            HeartbeatPointer = (Pointer)pHeartbeatHandle;
            VmAfClientLibrary.INSTANCE.VmAfdStopHeartbeat(HeartbeatPointer);
            HeartbeatPointer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSiteName(String server) {
        PointerByReference ppszSiteName = new PointerByReference();
        try {
            int errCode = VmAfClientLibrary.INSTANCE.VmAfdGetSiteNameA(server, ppszSiteName);
            if (errCode != 0) {
                throw new VmAfClientNativeException(errCode);
            }
            String string = ppszSiteName.getValue().getString(0L);
            return string;
        }
        finally {
            Pointer val = ppszSiteName.getValue();
            if (val != Pointer.NULL) {
                VmAfClientLibrary.INSTANCE.VmAfdFreeMemory(val);
            }
        }
    }

    public static interface VmAfClientLibrary
    extends Library {
        public static final VmAfClientLibrary INSTANCE = (VmAfClientLibrary)Native.loadLibrary((String)"vmafdclient", VmAfClientLibrary.class);

        public int VmAfdGetStatusA(String var1, IntByReference var2);

        public int VmAfdGetStatusW(WString var1, IntByReference var2);

        public int VmAfdTriggerRootCertsRefresh(String var1, String var2, String var3);

        public int VmAfdGetDomainNameA(String var1, PointerByReference var2);

        public int VmAfdGetDomainNameW(WString var1, PointerByReference var2);

        public int VmAfdSetDomainNameA(String var1, String var2);

        public int VmAfdSetDomainNameW(WString var1, WString var2);

        public int VmAfdGetDomainStateA(String var1, PointerByReference var2);

        public int VmAfdGetDomainStateW(WString var1, PointerByReference var2);

        public int VmAfdGetLDUA(String var1, PointerByReference var2);

        public int VmAfdGetLDUW(WString var1, PointerByReference var2);

        public int VmAfdSetLDUA(String var1, String var2);

        public int VmAfdSetLDUW(WString var1, WString var2);

        public int VmAfdGetRHTTPProxyPortA(String var1, IntByReference var2);

        public int VmAfdSetRHTTPProxyPortA(String var1, int var2);

        public int VmAfdSetRHTTPProxyPortW(WString var1, int var2);

        public int VmAfdSetDCPortA(String var1, int var2);

        public int VmAfdSetDCPortW(WString var1, int var2);

        public int VmAfdGetCMLocationA(String var1, PointerByReference var2);

        public int VmAfdGetCMLocationW(WString var1, PointerByReference var2);

        public int VmAfdGetLSLocationA(String var1, PointerByReference var2);

        public int VmAfdGetLSLocationW(WString var1, PointerByReference var2);

        public int VmAfdSetLSLocationW(WString var1, WString var2);

        public int VmAfdGetDCNameA(String var1, PointerByReference var2);

        public int VmAfdGetDCNameW(WString var1, PointerByReference var2);

        public int VmAfdGetDCNameExA(String var1, String var2, PointerByReference var3);

        public int VmAfdGetDCNameExW(WString var1, WString var2, PointerByReference var3);

        public int VmAfdGetDomainIdA(String var1, PointerByReference var2);

        public int VmAfdGetDomainIdW(WString var1, PointerByReference var2);

        public int VmAfdSetDCNameA(String var1, String var2);

        public int VmAfdSetDCNameW(WString var1, WString var2);

        public int VmAfdGetPNIDForUrlA(String var1, PointerByReference var2);

        public int VmAfdGetPNIDA(String var1, PointerByReference var2);

        public int VmAfdGetPNIDW(WString var1, PointerByReference var2);

        public int VmAfdSetPNIDA(String var1, String var2);

        public int VmAfdSetPNIDW(WString var1, WString var2);

        public int VmAfdGetMachineAccountInfoA(String var1, PointerByReference var2, PointerByReference var3);

        public int VmAfdGetMachineAccountInfoW(WString var1, PointerByReference var2, PointerByReference var3);

        public int VmAfdPromoteVmDirA(String var1, String var2, String var3, String var4, String var5, String var6);

        public int VmAfdPromoteVmDirW(WString var1, WString var2, WString var3, WString var4, WString var5, WString var6);

        public int VmAfdDemoteVmDirA(String var1, String var2, String var3);

        public int VmAfdDemoteVmDirW(WString var1, WString var2, WString var3);

        public int VmAfdJoinVmDirA(String var1, String var2, String var3, String var4, String var5, String var6);

        public int VmAfdJoinVmDirW(WString var1, WString var2, WString var3, WString var4, WString var5, WString var6);

        public int VmAfdLeaveVmDirA(String var1, String var2, String var3);

        public int VmAfdLeaveVmDirW(WString var1, WString var2, WString var3);

        public int VmAfdJoinADA(String var1, String var2, String var3, String var4, String var5);

        public int VmAfdJoinADW(WString var1, WString var2, WString var3, WString var4, WString var5);

        public int VmAfdLeaveADA(String var1, String var2, String var3);

        public int VmAfdLeaveADW(WString var1, WString var2, WString var3);

        public int VmAfdQueryADA(String var1, PointerByReference var2, PointerByReference var3, PointerByReference var4, PointerByReference var5);

        public int VmAfdQueryADW(WString var1, PointerByReference var2, PointerByReference var3, PointerByReference var4, PointerByReference var5);

        public int VmAfdGetSiteGUIDA(String var1, PointerByReference var2);

        public int VmAfdGetSiteGUIDW(WString var1, PointerByReference var2);

        public void VmAfdFreeMemory(Pointer var1);

        public int VmAfdGetSSLCertificate(String var1, PointerByReference var2, PointerByReference var3);

        public int VmAfdSetSSLCertificate(String var1, String var2, String var3);

        public int VmAfdSetMachineIDA(String var1, String var2);

        public int VmAfdSetMachineIDW(WString var1, WString var2);

        public int VmAfdGetMachineIDA(String var1, PointerByReference var2);

        public int VmAfdGetMachineIDW(WString var1, PointerByReference var2);

        public int VmAfdStartHeartbeatA(String var1, int var2, PointerByReference var3);

        public int VmAfdStartHeartbeatW(WString var1, int var2, PointerByReference var3);

        public int VmAfdStopHeartbeat(Pointer var1);

        public int VmAfdGetSiteNameA(String var1, PointerByReference var2);
    }
}

