/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import com.vmware.srm.client.utilities.Exceptions;
import com.vmware.srm.client.utilities.OperationWaiter;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableRetryWrapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallableRetryWrapper.class);
    private final Callable<T> _call;
    private final AtomicReference<OpWrapper> _opWrapperRef = new AtomicReference<Object>(null);

    public CallableRetryWrapper(Callable<T> call) {
        Validate.notNull(call, (String)"call");
        this._call = call;
    }

    public T get() {
        OpWrapper wrapper;
        while ((wrapper = this._opWrapperRef.get()) == null && !this._opWrapperRef.compareAndSet(null, wrapper = new OpWrapper())) {
        }
        return wrapper.invoke();
    }

    private class OpWrapper {
        private final ThreadLocal<Boolean> _doRun = ThreadLocal.withInitial(() -> false);
        private final OperationWaiter<T> _waiter = new OperationWaiter();

        OpWrapper() {
            this._doRun.set(true);
        }

        T invoke() {
            boolean doRun = this._doRun.get();
            this._doRun.remove();
            if (doRun) {
                try {
                    Object result = CallableRetryWrapper.this._call.call();
                    this._waiter.setResult(result);
                    return result;
                }
                catch (Exception exc) {
                    LOGGER.warn("Executing '{}' failed.", (Object)CallableRetryWrapper.this._call, (Object)exc);
                    this._waiter.setError(exc);
                    CallableRetryWrapper.this._opWrapperRef.lazySet(null);
                    throw Exceptions.getRuntimeException(exc);
                }
            }
            Exception exc = this._waiter.getError();
            if (exc != null) {
                throw Exceptions.getRuntimeException(exc);
            }
            return this._waiter.get();
        }
    }
}

