/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import com.vmware.srm.client.utilities.Exceptions;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class FirstSuccessExecutor<T> {
    private final Callable<T>[] _tasks;
    private final AtomicInteger _failedTasks = new AtomicInteger(0);
    private final ResultImpl<T> _result = new ResultImpl();

    @SafeVarargs
    public static <T> FirstResult<T> execute(Executor exec, Callable<T> ... tasks) {
        if (tasks.length == 0) {
            throw new IllegalArgumentException("tasks");
        }
        return new FirstSuccessExecutor<T>(tasks).start(exec);
    }

    FirstSuccessExecutor(Callable<T>[] tasks) {
        this._tasks = tasks;
    }

    FirstResult<T> start(Executor exec) {
        for (Callable<T> call : this._tasks) {
            exec.execute(new TaskAdapter(call));
        }
        return this._result;
    }

    private void taskComplete(Callable<T> task, T result) {
        this._result.setResult(task, result);
    }

    private void taskFailed(Callable<T> task, Exception error) {
        if (this._failedTasks.incrementAndGet() == this._tasks.length) {
            this._result.setError(task, error);
        }
    }

    private class TaskAdapter
    implements Runnable {
        private final Callable<T> _task;

        TaskAdapter(Callable<T> task) {
            this._task = task;
        }

        @Override
        public void run() {
            try {
                FirstSuccessExecutor.this.taskComplete(this._task, this._task.call());
            }
            catch (Exception e) {
                FirstSuccessExecutor.this.taskFailed(this._task, e);
            }
        }
    }

    private static class ResultImpl<T>
    implements FirstResult<T> {
        private CountDownLatch _latch = new CountDownLatch(1);
        private final AtomicReference<Callable<T>> _taskRef = new AtomicReference<Object>(null);
        private T _result;
        private Exception _error;

        private ResultImpl() {
        }

        @Override
        public <S extends Callable<T>> S getFirstSuccessTask() {
            this.waitForAdapter();
            if (this._error != null) {
                throw new TaskException(this._error);
            }
            return (S)this._taskRef.get();
        }

        @Override
        public T get() {
            this.waitForAdapter();
            if (this._error != null) {
                throw new TaskException(this._error);
            }
            return this._result;
        }

        @Override
        public Exception getError() {
            this.waitForAdapter();
            return this._error;
        }

        private void waitForAdapter() {
            try {
                this._latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Exceptions.getRuntimeException(e);
            }
        }

        void setResult(Callable<T> task, T result) {
            if (this._taskRef.compareAndSet(null, task)) {
                this._result = result;
                this._latch.countDown();
            }
        }

        void setError(Callable<T> task, Exception error) {
            if (this._taskRef.compareAndSet(null, task)) {
                this._error = error;
                this._latch.countDown();
            }
        }
    }

    public static interface FirstResult<T> {
        public <S extends Callable<T>> S getFirstSuccessTask() throws TaskException;

        public T get() throws TaskException;

        public Exception getError();
    }

    private static class TaskException
    extends RuntimeException {
        private static final long serialVersionUID = -3804056528269526911L;

        public TaskException(Throwable cause) {
            super(cause);
        }
    }
}

