/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadContext.class);
    private static final ThreadContext EMPTY = new ThreadContext();
    private static final ThreadLocal<ThreadContext> CURRENT = ThreadLocal.withInitial(() -> EMPTY);
    private final ThreadLocal<Boolean> _isApplied;
    private final Supplier<Object> _setter;
    private final Consumer<Object> _unsetter;
    private final ThreadContext _parent;
    private ThreadContext _child;

    private static <T> Callable<T> wrap(Runnable run) {
        return () -> {
            run.run();
            return null;
        };
    }

    public static ThreadContext get() {
        return CURRENT.get().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T setupContext(Callable<T> task, ThreadContext root) throws Exception {
        ThreadContext current = CURRENT.get();
        CURRENT.set(root);
        try {
            T t = root.execute(task);
            return t;
        }
        finally {
            CURRENT.set(current);
        }
    }

    public static <T> T setupContext(Callable<T> task, Supplier<Object> setter, Consumer<Object> unsetter) throws Exception {
        return ThreadContext.setupContext(task, new ThreadContext(null, setter, unsetter));
    }

    public static void setupContext(Runnable task, Supplier<Object> setter, Consumer<Object> unsetter) {
        try {
            ThreadContext.setupContext(ThreadContext.wrap(task), setter, unsetter);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            LOGGER.error("Internal error: ", (Object)task, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void setupContext(Runnable task, ThreadContext root) {
        try {
            ThreadContext.setupContext(ThreadContext.wrap(task), root);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            LOGGER.error("Internal error: ", (Object)task, (Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T extendContext(Callable<T> task, Supplier<Object> setter, Consumer<Object> unsetter) throws Exception {
        ThreadContext child = CURRENT.get().addChild(setter, unsetter);
        try {
            T t = child.execute(task);
            return t;
        }
        finally {
            child.remove();
        }
    }

    public static void extendContext(Runnable task, Supplier<Object> setter, Consumer<Object> unsetter) {
        try {
            ThreadContext.extendContext(ThreadContext.wrap(task), setter, unsetter);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            LOGGER.error("Internal error: ", (Object)task, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private ThreadContext() {
        this(null, () -> null, unused -> {});
    }

    private ThreadContext(ThreadContext parent, Supplier<Object> setter, Consumer<Object> unsetter) {
        this(parent, setter, unsetter, ThreadLocal.withInitial(() -> false));
    }

    private ThreadContext(ThreadContext parent, Supplier<Object> setter, Consumer<Object> unsetter, ThreadLocal<Boolean> isApplied) {
        Validate.notNull(setter, (String)"setter");
        Validate.notNull(unsetter, (String)"unsetter");
        Validate.notNull(isApplied, (String)"applied");
        this._parent = parent;
        this._setter = setter;
        this._unsetter = unsetter;
        this._isApplied = isApplied;
    }

    private ThreadContext addChild(Supplier<Object> setter, Consumer<Object> unsetter) {
        if (this._child == null) {
            ThreadContext child;
            this._child = child = new ThreadContext(this, setter, unsetter);
            return child;
        }
        return this._child.addChild(setter, unsetter);
    }

    private void remove() {
        if (this._parent != null) {
            if (this._parent._child != this) {
                LOGGER.error("Already removed", (Throwable)new IllegalStateException());
                return;
            }
            this._parent._child = null;
        }
    }

    private <T> T execute(Callable<T> task) throws Exception {
        return ThreadContext.execute(task, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(Callable<T> task, ThreadContext tc) throws Exception {
        if ((tc = ThreadContext.getContextToApply(tc)) == null) {
            return task.call();
        }
        Invoke helper = null;
        try {
            helper = new Invoke(tc);
        }
        catch (Exception e) {
            LOGGER.error("Failed to set thread context: ", (Throwable)e);
        }
        try {
            T t = ThreadContext.execute(task, tc._child);
            return t;
        }
        finally {
            if (helper != null) {
                try {
                    helper.doUnset();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to unset thread context ", (Throwable)e);
                }
            }
        }
    }

    private static ThreadContext getContextToApply(ThreadContext from) {
        while (from != null && from.isApplied()) {
            from = from._child;
        }
        return from;
    }

    private boolean isApplied() {
        return this._isApplied.get();
    }

    private Object set() {
        Object result = this._setter.get();
        this._isApplied.set(true);
        return result;
    }

    private void unset(Object arg) {
        try {
            this._unsetter.accept(arg);
        }
        finally {
            this._isApplied.set(false);
        }
    }

    protected ThreadContext clone() {
        if (this._parent != null) {
            throw new IllegalStateException("Cloning supported on root only.");
        }
        return this.clone(null);
    }

    private ThreadContext clone(ThreadContext parent) {
        ThreadContext result = new ThreadContext(parent, this._setter, this._unsetter, this._isApplied);
        if (this._child != null) {
            result._child = this._child.clone(result);
        }
        return result;
    }

    private static final class Invoke {
        private final Object _toUnset;
        private final ThreadContext _th;

        Invoke(ThreadContext th) {
            this._toUnset = th.set();
            this._th = th;
        }

        void doUnset() {
            this._th.unset(this._toUnset);
        }
    }
}

