/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.cdc;

public enum CdcAddressType {
    CDC_ADDRESS_TYPE_NO_ADDRESS(0),
    CDC_ADDRESS_TYPE_INET(1),
    CDC_ADDRESS_TYPE_NETBIOS(2);

    private final int _addressType;

    private CdcAddressType(int addressType) {
        this._addressType = addressType;
    }

    public int getValue() {
        return this._addressType;
    }

    public static CdcAddressType getEntryType(int type) {
        switch (type) {
            case 0: {
                return CDC_ADDRESS_TYPE_NO_ADDRESS;
            }
            case 1: {
                return CDC_ADDRESS_TYPE_INET;
            }
            case 2: {
                return CDC_ADDRESS_TYPE_NETBIOS;
            }
        }
        throw new IllegalArgumentException(String.format("Unidentified entity type [%d]", type));
    }
}

