/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.tool.ImpexStageExecutor;
import com.vmware.srm.client.impex.tool.InteractiveArrayManagerImporter;
import com.vmware.srm.client.impex.tool.SrmImpexStages;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrFault;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlImporter.class);

    public Promise<Void> importSrmConfigurables(Integer retriesDelay, Integer retriesCount, boolean allowOverrideProtectionSettings, SrmServersDataWrapper srmServersDataWrapper, ConfigurablesWrapper configurablesWrapper) {
        ImpexImportSrmContext.ImpexImportConfig importConfig = new ImpexImportSrmContext.ImpexImportConfig(retriesDelay.intValue(), retriesCount.intValue(), allowOverrideProtectionSettings);
        Callable<Promise> exportTask = () -> new InteractiveArrayManagerImporter().createArrayManagers().thenCompose(unused -> this.importSrmConfigurables());
        try {
            return (Promise)ImpexImportSrmContext.executeWith(exportTask, (ImpexImportSrmContext.ImpexImportConfig)importConfig, (SrmServersDataWrapper)srmServersDataWrapper, (ConfigurablesWrapper)configurablesWrapper);
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
    }

    private Promise<Void> importSrmConfigurables() {
        LOGGER.info("Import SRM configurables started.");
        return new SrmCmdStageExecutor().start().thenApply(unused -> {
            LOGGER.info("Import SRM configurables ended.");
            return null;
        });
    }

    private static final class SrmCmdStageExecutor
    extends CmdStageExecutor {
        private SrmCmdStageExecutor() {
        }

        @Override
        protected ImpexStageExecutor.ImpexStage initialStage() {
            return new SrmImpexStages.CollectServersData(new ImpexStageExecutor.StageParams());
        }

        @Override
        protected Void stageComplete(ImpexStageExecutor.ImpexStage stage, ImpexStageExecutor.ImpexStage nextStage, Void context) {
            this.logWarnings(ImpexImportSrmContext.get().getAndResetErrors());
            return context;
        }

        @Override
        protected void stageFailed(ImpexStageExecutor.ImpexStage stage, Exception cause, Void context) {
            this.logWarnings(ImpexImportSrmContext.get().getAndResetErrors());
        }
    }

    private static abstract class CmdStageExecutor
    extends ImpexStageExecutor<Void> {
        private CmdStageExecutor() {
        }

        protected abstract ImpexStageExecutor.ImpexStage initialStage();

        protected abstract Void stageComplete(ImpexStageExecutor.ImpexStage var1, ImpexStageExecutor.ImpexStage var2, Void var3);

        protected abstract void stageFailed(ImpexStageExecutor.ImpexStage var1, Exception var2, Void var3);

        protected void logWarnings(List<DrFault> faults) {
            if (faults.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (DrFault fault : faults) {
                sb.append('\n').append(fault.getMessage()).append(' ');
                String detail = fault.getDetail();
                if (detail == null) continue;
                sb.append(detail);
            }
            if (sb.length() > 0) {
                LOGGER.warn("Collected the following warnings:{}", (Object)sb);
            }
        }
    }
}

