/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.request;

import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.request.Request;
import org.apache.commons.lang.StringUtils;

public class KeyStoreRequest
extends Request<KeyStoreData> {
    private final IOHelper _ioHelper;

    public KeyStoreRequest(IOHelper ioHelper) {
        super(false);
        this._ioHelper = ioHelper;
    }

    @Override
    public KeyStoreData handle() {
        return this.collect();
    }

    private KeyStoreData collect() {
        String type = this._ioHelper.readln("Enter keystore type (or press Enter in case you use the default - JCEKS):");
        String path = this._ioHelper.readln("Enter keystore path:");
        String pass = this._ioHelper.readPass("Enter keystore password:");
        String certAlias = this._ioHelper.readln("Enter keystore certificate alias:");
        String keyAlias = this._ioHelper.readln("Enter keystore key alias:");
        String keyPass = this._ioHelper.readPass("Enter keystore key password:");
        return new KeyStoreData(this.processType(type), path, pass, certAlias, keyAlias, keyPass);
    }

    private String processType(String type) {
        return StringUtils.isEmpty(type) ? "JCEKS" : type;
    }
}

