/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.request;

import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.PromiseImpl;

public abstract class Request<T> {
    private final boolean _isFinal;
    private final PromiseImpl<T> _promise = new PromiseImpl();

    public Request(boolean isFinal) {
        this._isFinal = isFinal;
    }

    public Promise<T> getResult() {
        return this._promise;
    }

    public Promise<T> resolve(T result) {
        this._promise.setResult(result);
        return this.getResult();
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public final void execute() {
        try {
            T result = this.handle();
            this._promise.setResult(result);
        }
        catch (RuntimeException re) {
            this._promise.setError((Exception)re);
            throw re;
        }
    }

    public abstract T handle();

    public InputWaiterRequester.ExitStatus getExitStatus() {
        throw new IllegalStateException("Non-final request.");
    }
}

