/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.request;

import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.request.Request;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SrmSelectionRequest
extends Request<String> {
    private final IOHelper _ioHelper;
    private final Map<String, String> _guidToName;

    public SrmSelectionRequest(IOHelper ioHelper, Map<String, String> guidToName) {
        super(false);
        this._ioHelper = ioHelper;
        this._guidToName = guidToName;
    }

    @Override
    public String handle() {
        return this.collect();
    }

    private String collect() {
        int index;
        switch (this._guidToName.size()) {
            case 0: {
                this._ioHelper.writeln("No SRM servers found.");
                return null;
            }
            case 1: {
                String selectedSrmGuid = this._guidToName.keySet().toArray(new String[1])[0];
                this._ioHelper.writeln("One SRM server found: " + this._guidToName.get(selectedSrmGuid));
                return selectedSrmGuid;
            }
        }
        ArrayList<String> keys = new ArrayList<String>(this._guidToName.keySet());
        this._ioHelper.writeln("Available SRM servers:");
        for (int i = 0; i < keys.size(); ++i) {
            this._ioHelper.writeln(String.format("[%s] %s", i, this._guidToName.get(keys.get(i))));
        }
        while (true) {
            String input;
            if (!StringUtils.isNumeric(input = this._ioHelper.readln())) {
                this._ioHelper.writeln("Enter a number:");
                continue;
            }
            index = Integer.parseInt(input);
            if (index >= 0 && index < keys.size()) break;
            this._ioHelper.writeln(String.format("Enter a number in range [0:%s]:", keys.size() - 1));
        }
        return (String)keys.get(index);
    }
}

