/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.common;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.PromiseResult;
import com.vmware.srm.client.utilities.Exceptions;
import com.vmware.srm.client.utilities.OperationWaiter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class SyncUtils {
    public static <T> T getSync(Promise<T> promise) {
        OperationWaiter waiter = new OperationWaiter();
        promise.onSuccess(arg_0 -> ((OperationWaiter)waiter).setResult(arg_0)).onError(arg_0 -> ((OperationWaiter)waiter).setError(arg_0));
        Exception exc = waiter.getError();
        if (exc == null) {
            return (T)waiter.get();
        }
        throw Exceptions.getRuntimeException((Throwable)exc);
    }

    public static <T> T getSync(Promise<T> promise, long waitMillis) throws InterruptedException, OperationWaiter.OperationWaiterException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<Object> resultRef = new AtomicReference<Object>(null);
        promise.onError(exc -> {
            resultRef.set(PromiseResult.fromException((Throwable)exc));
            latch.countDown();
        }).onSuccess(result -> {
            resultRef.set(PromiseResult.fromResult((Object)result));
            latch.countDown();
        });
        if (!latch.await(waitMillis, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
        PromiseResult result2 = resultRef.get();
        if (result2.isSuccessful()) {
            return (T)result2.getResult();
        }
        throw new OperationWaiter.OperationWaiterException(result2.getError());
    }
}

