/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.common;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TaskMonitor<T> {
    private static ScheduledExecutorService EXEC = Utils.getScheduledExecutor();
    private long DELAY = 150L;
    private final Task _task;
    private final PromiseImpl<T> _promise;
    private final AtomicBoolean _started = new AtomicBoolean(false);

    public TaskMonitor(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task");
        }
        this._task = task;
        this._promise = new PromiseImpl();
    }

    @Deprecated
    public Promise<T> start() {
        if (!this._started.compareAndSet(false, true)) {
            throw new IllegalStateException("Already started.");
        }
        this._task.getInfo((Future)new MonitorFuture());
        return this._promise;
    }

    private void onTaskInfoComplete(MonitorFuture future, TaskInfo info, Exception err) {
        Exception taskError;
        Exception exception = taskError = err == null ? info.getError() : err;
        if (taskError != null) {
            this._promise.setError(taskError);
            return;
        }
        TaskInfo.State state = info.getState();
        if (state == TaskInfo.State.success) {
            this._promise.setResult(info.getResult());
            return;
        }
        long now = System.currentTimeMillis();
        long delay = now - future.creationTime;
        EXEC.schedule(new Runnable(){

            @Override
            public void run() {
                TaskMonitor.this._task.getInfo((Future)new MonitorFuture());
            }
        }, this.DELAY - delay, TimeUnit.MILLISECONDS);
    }

    private class MonitorFuture
    extends BlockingFuture<TaskInfo> {
        final long creationTime = System.currentTimeMillis();

        private MonitorFuture() {
        }

        public void set(TaskInfo ret) {
            super.set((Object)ret);
            TaskMonitor.this.onTaskInfoComplete(this, ret, null);
        }

        public void setException(Exception fault) {
            super.setException(fault);
            TaskMonitor.this.onTaskInfoComplete(this, null, fault);
        }
    }
}

