/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BasePairNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.HmsHelper;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.PairSetupPublisher;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsPairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsServerImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.SessionManager;
import com.vmware.vim.binding.hms.fault.AlreadyLoggedIn;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.Future;
import java.util.function.Supplier;

class HmsPairNode
extends BasePairNode<HmsServerImpl, HmsPairSetupImpl, HmsHelper.PairInfo> {
    HmsPairNode(HmsServerImpl hms, HmsHelper.PairInfo info, PairSetupPublisher<HmsPairSetupImpl> publisher) {
        super(info.lsppUrl, info.lsppThumbprint, hms.guid(), info.hmsUuid, hms, info, publisher);
    }

    @Override
    protected HmsPairSetupImpl createPairSetup(ServersViewImpl view, HmsServerImpl server, HmsHelper.PairInfo info) {
        return new HmsPairSetupImpl(view, server, info.lsppUrl, info.lsppThumbprint, info.name, info.hmsUuid, info.vcGuid, info.vcName, info.remoteServerVmomiRef);
    }

    @Override
    protected void completePairSetup(HmsPairSetupImpl ps, TokenProvider tp) {
        ps.complete(new LoginRemoteSiteTask(ps, tp));
    }

    private static class LoginRemoteSiteTask
    implements Supplier<Promise<Void>> {
        private final HmsPairSetupImpl _pairSetup;
        private final TokenProvider _provider;

        LoginRemoteSiteTask(HmsPairSetupImpl pairSetup, TokenProvider provider) {
            this._pairSetup = pairSetup;
            this._provider = provider;
        }

        @Override
        public Promise<Void> get() {
            Promise<SamlToken> delToken = this.getDelegatedToken();
            HmsService service = (HmsService)((HmsServer)this._pairSetup.server()).service();
            Promise sm = service.getContent().thenApply(content -> (SessionManager)service.createStub(content.getSessionManager()));
            return sm.thenCombineCompose(delToken, (manager, token) -> {
                FuturePromise result = new FuturePromise();
                manager.loginHmsServerByToken(this._pairSetup.pairServerVmomiRef(), token.toXml(), L10N.getLocaleId(), (Future)result);
                return result.materialize().thenCompose(pr -> {
                    if (pr.isSuccessful()) {
                        return Promises.resolve(null);
                    }
                    Exception cause = pr.getError();
                    if (cause instanceof AlreadyLoggedIn) {
                        return Promises.resolve(null);
                    }
                    return Promises.reject((Exception)cause);
                });
            });
        }

        private Promise<SamlToken> getDelegatedToken() {
            return this._pairSetup.getPairServer().thenCompose(hms -> ((HmsService)hms.service()).getContent()).thenApply(ServiceInstanceContent::getSolutionUsername).thenCompose(su -> Promises.from(() -> this._provider.acquireDelegatedToken((String)su)));
        }
    }
}

