/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseVmomiNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.HmsNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.SrmNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.VmomiExtensionServerNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.vc.VcServerImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.pbm.SpbmServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vc.VcServiceImpl;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcNode
extends BaseVmomiNode<VcServiceImpl, VcServerImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcNode.class);
    private volatile LsppHelper.DrSite _currentSite;
    private volatile SpbmServiceImpl _spbmService;

    private static SpbmServiceImpl createSpbmService(LsppService spbmReg, TokenProvider tp) throws GeneralSecurityException, IOException {
        String owner = spbmReg.getOwnerId();
        String su = owner.split("@")[0];
        LsppServiceEndpoint ep = LsppHelper.getEndpoint(spbmReg, "https", "com.vmware.vim.pbm");
        if (ep == null) {
            LOGGER.error("Failed to 'https' endpoint from pbm registration: {}", (Object)spbmReg);
            throw new IllegalArgumentException("spbmReg");
        }
        KeyStore store = CertificateUtils.createTrustStore(ep.getCertificates());
        return new SpbmServiceImpl(ep.url, store, tp, su);
    }

    VcNode(LsppHelper.DrSite site, ServersViewImpl.Publisher publisher, TokenProvider tokenProvider, boolean local) {
        super(site.getVcReg(), "com.vmware.vim", tokenProvider, local, publisher);
        this._currentSite = site;
    }

    @Override
    protected void added(NodeContext context, NodeContext.NestedContext nodeContext) {
    }

    @Override
    protected void update(Node<NodeContext> suggested, NodeContext context, NodeContext.NestedContext nodeContext) {
        VcNode suggestedVc = (VcNode)suggested;
        LsppService thisSpbmReg = this._currentSite.getSpbmReg();
        LsppService suggestedSpbmReg = suggestedVc._currentSite.getSpbmReg();
        LOGGER.trace("Updating 'DrSite' for '{}' from '{}'", (Object)this, (Object)suggestedVc);
        this._currentSite = suggestedVc._currentSite;
        suggestedVc._currentSite = null;
        if (!thisSpbmReg.equals(suggestedSpbmReg)) {
            LOGGER.trace("SPBM registration changed from '{}' to '{}'.", (Object)thisSpbmReg, (Object)suggestedSpbmReg);
            if (this._spbmService != null) {
                this._spbmService.dispose();
            }
            this._spbmService = null;
        }
    }

    @Override
    VcServiceImpl createService(URI url, KeyStore ks, TokenProvider tp) {
        return new VcServiceImpl(url, ks, tp);
    }

    @Override
    protected VcServerImpl createServer(ServersViewImpl view, VcServiceImpl service, LsppService serviceReg, LsppServiceEndpoint vmomiEp, List<CertificateValidityInfo> certificateIssues) {
        if (this._spbmService == null) {
            try {
                this._spbmService = VcNode.createSpbmService(this._currentSite.getSpbmReg(), this.getTokenProvider());
            }
            catch (Exception exc) {
                LOGGER.error("Failed to create SpbmService for {} with VC {}", new Object[]{this._currentSite.getSpbmReg(), this.getServerReg(), exc});
                throw Exceptions.getRuntimeException(exc);
            }
        }
        return new VcServerImpl(vmomiEp.url, service, serviceReg.getId(), this.isLocal(), certificateIssues, this._spbmService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(ServersViewImpl.Publisher publisher, VcServiceImpl service, VcServerImpl server) {
        try {
            HashSet<VmomiExtensionServerNode> result = new HashSet<VmomiExtensionServerNode>();
            LsppHelper.DrSite site = this._currentSite;
            LsppService hmsReg = site.getHmsReg();
            if (hmsReg != null) {
                result.add(new HmsNode(hmsReg, this.getTokenProvider(), this.isLocal(), publisher.createPublisher(), server));
            }
            for (LsppService srm : site.getSrmRegs()) {
                result.add(new SrmNode(srm, this.getTokenProvider(), this.isLocal(), publisher.createPublisher(), server));
            }
            Promise promise = Promises.resolve(result);
            return promise;
        }
        finally {
            publisher.complete();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        SpbmServiceImpl spbmService = this._spbmService;
        this._spbmService = null;
        if (spbmService != null) {
            spbmService.dispose();
        }
    }
}

