/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.StsProxyBase;
import com.vmware.srm.client.topology.impl.sso.StsUtils;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.utilities.Disposable;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackHelper;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.pool.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTokenServiceProxy {
    private static Factory PROTOTYPE;
    private static CallbackHelper FILTER;
    private static final Logger LOGGER;
    private static final ObjectPoolDisposer DISPOSER;

    private static void dispose(ObjectPool pool) {
        try {
            pool.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to dispose objectPool:", (Throwable)e);
        }
    }

    public static DrSecurityTokenService create(SecurityTokenServiceConfig config) {
        URI url = SecurityTokenServiceProxy.getUrl(config);
        ObjectPool pool = StsUtils.createPool(config);
        Context context = new Context(url, SecurityTokenServiceProxy.getPrivateKey(config), pool);
        DrSecurityTokenService result = (DrSecurityTokenService)PROTOTYPE.newInstance(new Class[]{Object.class}, new Object[]{context}, FILTER.getCallbacks());
        DISPOSER.register(result, pool);
        return result;
    }

    private static URI getUrl(SecurityTokenServiceConfig config) {
        try {
            return config.getConnectionConfig().getUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static PrivateKey getPrivateKey(SecurityTokenServiceConfig config) {
        return (PrivateKey)config.getHolderOfKeyConfig().getPrivateKey();
    }

    static {
        FILTER = new FilterImpl();
        LOGGER = LoggerFactory.getLogger(SecurityTokenServiceProxy.class);
        DISPOSER = new ObjectPoolDisposer();
        try {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(StsProxyBase.class);
            enhancer.setUseFactory(true);
            enhancer.setCallbackFilter((CallbackFilter)FILTER);
            enhancer.setCallbackTypes(FILTER.getCallbackTypes());
            enhancer.setCallbacks(FILTER.getCallbacks());
            PROTOTYPE = (Factory)enhancer.create(new Class[0], new Object[0]);
            DISPOSER.start();
        }
        catch (Exception e) {
            LOGGER.error("static ctor failed: ", (Throwable)e);
        }
    }

    static class ObjectPoolDisposer
    extends Thread {
        private final ReferenceQueue<SecurityTokenService> _queue = new ReferenceQueue();
        private final Set<Ref> _refs = new HashSet<Ref>();

        ObjectPoolDisposer() {
            super("topology-sts-pool-disposer");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Ref ref = (Ref)this._queue.remove();
                    SecurityTokenServiceProxy.dispose(ref.pool);
                    Set<Ref> set = this._refs;
                    synchronized (set) {
                        this._refs.remove(ref);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("ObjectPoolDisposer interrupted.");
                Thread.currentThread().interrupt();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(SecurityTokenService sts, ObjectPool pool) {
            Ref ref = new Ref(sts, pool, this._queue);
            Set<Ref> set = this._refs;
            synchronized (set) {
                this._refs.add(ref);
            }
        }

        static class Ref
        extends WeakReference<SecurityTokenService> {
            ObjectPool pool;

            Ref(SecurityTokenService sts, ObjectPool pool, ReferenceQueue<SecurityTokenService> queue) {
                super(sts, queue);
                this.pool = pool;
            }
        }
    }

    private static final class Context {
        final URI url;
        final PrivateKey privateKey;
        final ObjectPool pool;

        private Context(URI url, PrivateKey privateKey, ObjectPool pool) {
            this.url = url;
            this.privateKey = privateKey;
            this.pool = pool;
        }
    }

    private static class FilterImpl
    extends CallbackHelper {
        private static final StsInterceptor STS_INTERCEPT = new StsInterceptor();
        private static final DrStsInterceptor DR_STS_INTERCEPT = new DrStsInterceptor();
        private static final DisposeInterceptor DISPOSE_INTERCEPT = new DisposeInterceptor();

        FilterImpl() {
            super(StsProxyBase.class, new Class[0]);
        }

        protected Object getCallback(Method method) {
            if (SecurityTokenService.class.equals(method.getDeclaringClass())) {
                return STS_INTERCEPT;
            }
            if (DrSecurityTokenService.class.equals(method.getDeclaringClass())) {
                return DR_STS_INTERCEPT;
            }
            if (Disposable.class.equals(method.getDeclaringClass())) {
                return DISPOSE_INTERCEPT;
            }
            return NoOp.INSTANCE;
        }
    }

    private static final class DisposeInterceptor
    implements MethodInterceptor {
        private DisposeInterceptor() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            StsProxyBase base = (StsProxyBase)proxy;
            ObjectPool pool = ((Context)base.getContext()).pool;
            SecurityTokenServiceProxy.dispose(pool);
            return null;
        }
    }

    private static final class DrStsInterceptor
    implements MethodInterceptor {
        private static final Method GET_URL;
        private static final Method GET_PRIVATE_KEY;

        private DrStsInterceptor() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            StsProxyBase base = (StsProxyBase)proxy;
            Context context = (Context)base.getContext();
            if (GET_URL.equals(method)) {
                return context.url;
            }
            if (GET_PRIVATE_KEY.equals(method)) {
                return context.privateKey;
            }
            throw new UnsupportedOperationException(method.toString());
        }

        static {
            try {
                GET_URL = DrSecurityTokenService.class.getDeclaredMethod("getUrl", new Class[0]);
                GET_PRIVATE_KEY = DrSecurityTokenService.class.getDeclaredMethod("getPrivateKey", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static final class StsInterceptor
    implements MethodInterceptor {
        private StsInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target;
            StsProxyBase base = (StsProxyBase)proxy;
            ObjectPool pool = ((Context)base.getContext()).pool;
            try {
                target = pool.borrowObject();
            }
            catch (Exception e) {
                Class<?>[] declaredExceptions;
                for (Class<?> ex : declaredExceptions = method.getExceptionTypes()) {
                    if (!ex.isInstance(e)) continue;
                    throw e;
                }
                throw Exceptions.getRuntimeException(e);
            }
            try {
                Object object = methodProxy.invoke(target, args);
                return object;
            }
            finally {
                pool.returnObject(target);
            }
        }
    }
}

