/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SsoUtils {
    public static final KeyPair KEY_PAIR;
    public static final X509Certificate CERT;
    private static final String SSO_ADMIN_POINT = "com.vmware.cis.cs.identity.admin";
    private static final String SSO_REST_POINT = "com.vmware.cis.cs.identity.sso";

    public static X509Certificate[] generateRootCertificates(String[] certArray) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (String c : certArray) {
            ByteArrayInputStream is = new ByteArrayInputStream(Base64.decodeBase64((String)c));
            certList.add((X509Certificate)factory.generateCertificate(is));
        }
        return certList.toArray(new X509Certificate[0]);
    }

    static SecurityTokenServiceConfig createStsConfig(URL stsUrl, X509Certificate hokCerificate, PrivateKey hokPrivateKey, X509Certificate[] stsCerts, String thumbprint, X509Certificate[] rootCerts) {
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)hokPrivateKey, hokCerificate, null);
        return SsoUtils.createStsConfig(stsUrl, stsCerts, thumbprint, rootCerts, hokConfig);
    }

    public static SecurityTokenServiceConfig createBearerStsConfig(URL stsUrl, X509Certificate[] stsCerts, String thumbprint, X509Certificate[] rootCerts) {
        return SsoUtils.createStsConfig(stsUrl, stsCerts, thumbprint, rootCerts, null);
    }

    private static SecurityTokenServiceConfig createStsConfig(URL stsUrl, X509Certificate[] stsCerts, String thumbprint, X509Certificate[] rootCerts, SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig) {
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(stsUrl, stsCerts, thumbprint, null, false);
        return new SecurityTokenServiceConfig(connConfig, rootCerts, null, hokConfig);
    }

    public static LsppServiceEndpoint getStsEndpoint(LsppService sso) {
        return SsoUtils.getEndpoint(sso, SSO_REST_POINT);
    }

    public static LsppServiceEndpoint getAdminEndpoint(LsppService sso) {
        return SsoUtils.getEndpoint(sso, SSO_ADMIN_POINT);
    }

    private static LsppServiceEndpoint getEndpoint(LsppService sso, String type) {
        if (sso == null || sso.getEndpoints() == null) {
            throw new IllegalArgumentException("sso");
        }
        for (LsppServiceEndpoint ep : sso.getEndpoints()) {
            if (!type.equals(ep.type)) continue;
            return ep;
        }
        String msg = String.format("No endpoint '%s' defined for service %s.", type, sso);
        throw new IllegalArgumentException(msg);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KEY_PAIR = CertificateUtils.generateKeyPair();
        CERT = CertificateUtils.generateSelfSignedCert(KEY_PAIR);
    }
}

