/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.view;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.core.Future;
import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerImpl<S extends ManagedObject, T extends Service<S, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerImpl.class);
    protected final URI _url;
    protected final T _service;
    protected final String _guid;
    protected final boolean _isLocal;
    protected final List<CertificateValidityInfo> _certificateIssues;
    private final AtomicReference<Promise<Server.Status>> _statusRef = new AtomicReference<Object>(null);

    private static Server.Status getStatus(Exception exc) {
        Validate.notNull((Object)exc, (String)"exc");
        if (exc instanceof SslException) {
            return Server.Status.ssl_error;
        }
        if (exc instanceof TransportProtocolException) {
            return Server.Status.no_connection;
        }
        if (exc instanceof ConnectionException) {
            return Server.Status.no_connection;
        }
        if (exc instanceof NotAuthenticated) {
            return Server.Status.not_authenticated;
        }
        if (exc instanceof TokenProvider.AuthenticationTokenNotAvailable) {
            return Server.Status.not_authenticated;
        }
        if (exc instanceof Service.LoginFailedException) {
            return Server.Status.login_failed;
        }
        LOGGER.error("Internal error occurred: ", (Throwable)exc);
        return Server.Status.internal_error;
    }

    public ServerImpl(URI url, T service, String guid, boolean isLocal, List<CertificateValidityInfo> certificateIssues) {
        this._url = url;
        this._service = service;
        this._guid = guid;
        this._isLocal = isLocal;
        this._certificateIssues = certificateIssues;
    }

    public Promise<Server.Status> getStatus() {
        Promise<Server.Status> current = this._statusRef.get();
        if (current != null) {
            return current;
        }
        PromiseImpl myStatus = new PromiseImpl();
        if (!this._statusRef.compareAndSet(null, (Promise<Server.Status>)myStatus)) {
            return this._statusRef.get();
        }
        this._service.getServiceInstance().thenCompose(si -> {
            FuturePromise result = new FuturePromise();
            this.currentTime(si, (Future<Calendar>)result);
            return result;
        }).onSuccess(unused -> myStatus.setResult((Object)Server.Status.ok)).onError(exc -> myStatus.setResult((Object)ServerImpl.getStatus(exc)));
        return myStatus;
    }

    public URI url() {
        return this._url;
    }

    public T service() {
        return this._service;
    }

    public String guid() {
        return this._guid;
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public List<CertificateValidityInfo> certificateIssues() {
        if (this._certificateIssues == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._certificateIssues);
    }

    protected abstract void currentTime(S var1, Future<Calendar> var2);
}

