/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.view.availability;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.version.VersionUtils;
import com.vmware.srm.client.utilities.ExecuteOnceOpWrapper;
import com.vmware.srm.client.utilities.StringUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.util.HashMap;
import java.util.function.Supplier;

public abstract class PairSetupImpl<T extends ExtensionServer<?>>
implements PairSetup<T> {
    private final ServersViewImpl _view;
    private final T _server;
    private final String _pairServerName;
    private final URI _pairLsppUrl;
    private final String _pairLsppThumbprint;
    private final String _pairServerGuid;
    private final String _pairVcGuid;
    private final String _pairVcName;
    private final ManagedObjectReference _pairServerVmomiRef;
    private final PromiseImpl<Supplier<Promise<Void>>> _completePromise = new PromiseImpl();
    private final ExecuteOnceOpWrapper<Promise<Void>> _remoteLoginWrapper = new ExecuteOnceOpWrapper(() -> this._completePromise.thenCompose(Supplier::get));

    public PairSetupImpl(ServersViewImpl view, T server, URI pairLsppUrl, String pairLsppThumbprint, String pairServerName, String pairServerGuid, String pairVcGuid, String pairVcName, ManagedObjectReference pairServerVmomiRef) {
        this._view = view;
        this._server = server;
        this._pairLsppUrl = pairLsppUrl;
        this._pairLsppThumbprint = pairLsppThumbprint;
        this._pairServerName = pairServerName;
        this._pairServerGuid = pairServerGuid;
        this._pairVcGuid = pairVcGuid;
        this._pairVcName = pairVcName;
        this._pairServerVmomiRef = pairServerVmomiRef;
    }

    @Override
    public T server() {
        return this._server;
    }

    @Override
    public ManagedObjectReference pairServerVmomiRef() {
        return this._pairServerVmomiRef;
    }

    @Override
    public String pairServerName() {
        return this._pairServerName;
    }

    @Override
    public String pairServerGuid() {
        return this._pairServerGuid;
    }

    @Override
    public String pairVcGuid() {
        return this._pairVcGuid;
    }

    @Override
    public String pairVcName() {
        return this._pairVcName;
    }

    public URI pairLsppUrl() {
        return this._pairLsppUrl;
    }

    public String pairLsppThumbprint() {
        return this._pairLsppThumbprint;
    }

    @Override
    public Promise<T> getPairServer() {
        return this._completePromise.thenCompose(unused -> this._view.getServerByInternal(this._pairServerGuid));
    }

    @Override
    public Promise<Void> remoteLogin() {
        return (Promise)this._remoteLoginWrapper.invoke().get();
    }

    @Override
    public Promise<VmodlVersion> getCommonVmodlVersion() {
        Promise<VmodlVersion> serverVersion = this.server().service().getVersion();
        Promise pairServerVersion = this.getPairServer().thenApply(Server::service).thenCompose(Service::getVersion);
        return serverVersion.thenCombine(pairServerVersion, (v1, v2) -> {
            if (VersionUtils.isCompatible(v1, v2)) {
                return v2;
            }
            if (VersionUtils.isCompatible(v2, v1)) {
                return v1;
            }
            String msg = "No common vmodl version found for pair setup '" + this + "'. Version: " + v1 + ". Pair version: " + v2 + ".";
            throw new RuntimeException(msg);
        });
    }

    public void complete(Supplier<Promise<Void>> doRemoteLogin) {
        this._completePromise.setResult(doRemoteLogin);
    }

    public void complete(Exception err) {
        this._completePromise.setError((Exception)new PairSetup.PairSetupException(err));
    }

    public Promise<Void> getComplete() {
        return this._completePromise.thenApply(unused -> null);
    }

    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_server", this._server);
        members.put("_pairLsppUrl", this._pairLsppUrl);
        members.put("_pairLsppsThumbprint", this._pairLsppThumbprint);
        members.put("_pairServerGuid", this._pairServerGuid);
        return StringUtils.getToStringValue((String)"PairSetupImpl", members);
    }
}

