/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi;

import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.utilities.OperationWaiter;

public class ConnectionParams {
    private static final int CONNECT_TIMEOUT;
    private static final int SOCKET_TIMEOUT;
    private static final int MAX_CONNECTIONS;
    private static final int MAX_CONNECTIONS_PER_ROUTE;

    public static int getConnectTimeout() {
        return CONNECT_TIMEOUT;
    }

    public static int getSocketTimeout() {
        return SOCKET_TIMEOUT;
    }

    public static int getMaxConnections() {
        return MAX_CONNECTIONS;
    }

    public static int getMaxConnectionsPerRoute() {
        return MAX_CONNECTIONS_PER_ROUTE;
    }

    static {
        OperationWaiter<Void> waiter = Config.get().ensureLoaded();
        if (waiter.getError() == null) {
            CONNECT_TIMEOUT = Long.valueOf(Config.get().getConnectTimeout()).intValue();
            SOCKET_TIMEOUT = Long.valueOf(Config.get().getSocketTimeout()).intValue();
            MAX_CONNECTIONS = Config.get().getMaxConnections();
            MAX_CONNECTIONS_PER_ROUTE = Config.get().getMaxConnectionsPerRoute();
        } else {
            CONNECT_TIMEOUT = Config.DEFAULT_CONNECT_TIMEOUT.intValue();
            SOCKET_TIMEOUT = Config.DEFAULT_SOCKET_TIMEOUT.intValue();
            MAX_CONNECTIONS = Config.DEFAULT_MAX_CONNECTIONS;
            MAX_CONNECTIONS_PER_ROUTE = Config.DEFAULT_MAX_CONNECTIONS_PER_ROUTE;
        }
    }
}

