/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.srm;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigurationManager;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VersionsXmlServiceImpl;
import com.vmware.vim.binding.dr.ServiceInstance;
import com.vmware.vim.binding.dr.ServiceInstanceContent;
import com.vmware.vim.binding.dr.version.internal.version12;
import com.vmware.vim.binding.dr.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;

public class SrmServiceImpl
extends VersionsXmlServiceImpl<ServiceInstance, ServiceInstanceContent>
implements SrmService {
    private static final Class<? extends Annotation> MIN_SUPPORTED_VERSION = version12.class;
    public static final Class<? extends Annotation> VERSION = versions.DR_VERSION_DOTTED;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;
    private static final SrmHttpConfigurationManager MANAGER;

    public SrmServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider, String versionsXmlPath) {
        super(server, SrmServiceImpl.MANAGER.getConfiguration(), VMODL_INIT, MIN_SUPPORTED_VERSION, tokenProvider, SERVICE_INSTANCE, "Site Recovery Manager Server", versionsXmlPath);
        MANAGER.addThumbprints(store);
    }

    @Override
    protected String getServerGuid(ServiceInstanceContent content) {
        return content.getSiteUuid();
    }

    @Override
    protected Promise<ServiceInstanceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.retrieveContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceInstanceContent content, String locale) {
        return this.createLoginStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.loginByToken(locale, (Future)result);
            return result;
        }).thenApply(unused -> null);
    }

    @Override
    protected Promise<Void> logout(ServiceInstanceContent content) {
        return this.createFreeStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        });
    }

    static {
        MANAGER = new SrmHttpConfigurationManager();
        VmodlContext context = VmodlContext.initContext((String[])new String[0]);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("DrServiceInstance", "DrServiceInstance", null);
    }

    private static final class SrmHttpConfigurationManager
    extends HttpConfigurationManager {
        private SrmHttpConfigurationManager() {
        }

        private HttpConfiguration getConfiguration() {
            return this._httpConfiguration;
        }
    }
}

