/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VmomiServiceImpl;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.annotation.Annotation;
import java.net.URI;
import org.apache.commons.lang.Validate;

public abstract class FixedVersionServiceImpl<S extends ManagedObject, D extends DataObject>
extends VmomiServiceImpl<S, D> {
    private final Class<? extends Annotation> _version;

    public FixedVersionServiceImpl(URI server, HttpConfiguration httpConfiguration, VmodlContextInitializer vmodlInitializer, TokenProvider provider, ManagedObjectReference siRef, String serverDescription, Class<? extends Annotation> versionClass) {
        super(server, httpConfiguration, vmodlInitializer, provider, siRef, serverDescription);
        Validate.notNull(versionClass, (String)"versionClass");
        this._version = versionClass;
    }

    @Override
    protected Promise<VmodlVersion> negotiateVersion() {
        VmodlVersion vv = this.getVersionMap().getVersion(this._version);
        if (vv == null) {
            return Promises.reject((Exception)new IllegalStateException("Unable to find vmodl version for '" + this._version + "'"));
        }
        return Promises.resolve((Object)vv);
    }
}

