/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public final class SessionWrapper {
    private static final String TOPOLOGY_KEY = "dr-topology";
    private static final String SESSION_USERNAME_KEY = "dr-web-sso-username";
    private static final String SESSION_INDEX_KEY = "dr-session-index";
    private static final String INITAL_REDIRECT_PATH_KEY = "dr.websso.redirect";
    private static final String AUTH_STRATEGY = "dr.authentication.strategy";
    private static final String SESSION_ID_ALIAS = "dr-session-id-alias";
    private static final ConcurrentMap<String, HttpSession> SESSION_BY_INDEX = new ConcurrentHashMap<String, HttpSession>();

    private SessionWrapper() {
    }

    public static boolean addSession(HttpSession session, String sessionIndex) {
        HttpSession current = SESSION_BY_INDEX.putIfAbsent(sessionIndex, session);
        return current == null || session.equals(current);
    }

    public static HttpSession removeSession(String sessionIndex) {
        return (HttpSession)SESSION_BY_INDEX.remove(sessionIndex);
    }

    public static <T> T getAttribute(HttpSession session, String attribute) {
        Validate.notNull((Object)session, (String)"session");
        return (T)session.getAttribute(attribute);
    }

    public static <T> void setAttribute(HttpSession session, String attribute, T value) {
        Validate.notNull((Object)session, (String)"session");
        session.setAttribute(attribute, value);
    }

    public static AuthenticationStrategy getAuthStrategy(HttpSession session) {
        return (AuthenticationStrategy)SessionWrapper.getAttribute(session, AUTH_STRATEGY);
    }

    public static void setAuthStrategy(HttpSession session, AuthenticationStrategy authStrategy) {
        SessionWrapper.setAttribute(session, AUTH_STRATEGY, authStrategy);
    }

    public static TopologyImpl getTopology(HttpSession session) {
        return (TopologyImpl)SessionWrapper.getAttribute(session, TOPOLOGY_KEY);
    }

    public static void setTopology(HttpSession session, TopologyImpl topology) {
        SessionWrapper.setAttribute(session, TOPOLOGY_KEY, topology);
    }

    public static String getUsername(HttpSession session) {
        return (String)SessionWrapper.getAttribute(session, SESSION_USERNAME_KEY);
    }

    public static void setUsername(HttpSession session, String username) {
        SessionWrapper.setAttribute(session, SESSION_USERNAME_KEY, username);
    }

    public static String getSessionIndex(HttpSession session) {
        return (String)SessionWrapper.getAttribute(session, SESSION_INDEX_KEY);
    }

    public static void setSessionIndex(HttpSession session, String sessionIndex) {
        SessionWrapper.setAttribute(session, SESSION_INDEX_KEY, sessionIndex);
    }

    public static String getInitialRedirectPath(HttpSession session) {
        try {
            String string = (String)SessionWrapper.getAttribute(session, INITAL_REDIRECT_PATH_KEY);
            return string;
        }
        finally {
            SessionWrapper.setAttribute(session, INITAL_REDIRECT_PATH_KEY, null);
        }
    }

    public static void setInitialRedirectPath(HttpSession session, String redirectPath) {
        SessionWrapper.setAttribute(session, INITAL_REDIRECT_PATH_KEY, redirectPath);
    }

    public static String getSessionIdAlias(HttpSession session) {
        return (String)SessionWrapper.getAttribute(session, SESSION_ID_ALIAS);
    }

    public static void setSessionIdAlias(HttpSession session, String sessionIdAlias) {
        SessionWrapper.setAttribute(session, SESSION_ID_ALIAS, sessionIdAlias);
    }
}

