/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authorization.data;

import com.vmware.srm.client.infrastructure.authorization.data.PrivilegeAvailability;
import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrFault;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrFaultImpl;
import com.vmware.srm.client.utilities.StringUtils;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Arrays;
import java.util.stream.Collectors;

public class EntityPrivilege
implements DrData {
    private MoRefData _moRef;
    private PrivilegeAvailability[] _privilegeAvailabilities;
    private DrFault _error;

    public EntityPrivilege() {
    }

    public EntityPrivilege(ManagedObjectReference moRef, PrivilegeAvailability[] privilegeAvailabilities) {
        this(new MoRefData(moRef), privilegeAvailabilities);
    }

    public EntityPrivilege(MoRefData moRef, PrivilegeAvailability[] privilegeAvailabilities) {
        this._moRef = moRef;
        this._privilegeAvailabilities = privilegeAvailabilities;
    }

    public EntityPrivilege(ManagedObjectReference moRef, PrivilegeAvailability[] privilegeAvailabilities, Exception ex) {
        this(new MoRefData(moRef), privilegeAvailabilities, DrFaultImpl.from(ex));
    }

    public EntityPrivilege(MoRefData moRef, PrivilegeAvailability[] privilegeAvailabilities, DrFault ex) {
        this(moRef, privilegeAvailabilities);
        this._error = ex;
    }

    public MoRefData getMoRef() {
        return this._moRef;
    }

    public void setMoRef(MoRefData moRef) {
        this._moRef = moRef;
    }

    public PrivilegeAvailability[] getPrivilegeAvailabilities() {
        return this._privilegeAvailabilities;
    }

    public void setPrivilegeAvailabilities(PrivilegeAvailability[] privilegeAvailabilities) {
        this._privilegeAvailabilities = privilegeAvailabilities;
    }

    public void setPrivilegeAvailabilities(AuthorizationManager.PrivilegeAvailability[] privilegeAvailabilities) {
        this._privilegeAvailabilities = Arrays.stream(privilegeAvailabilities).map(item -> new PrivilegeAvailability(item.getPrivId(), item.isIsGranted())).collect(Collectors.toList()).toArray(new PrivilegeAvailability[privilegeAvailabilities.length]);
    }

    public DrFault getError() {
        return this._error;
    }

    public void setError(DrFault error) {
        this._error = error;
    }

    @Override
    public String toString() {
        return "EntityPrivilege {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_moRef = ", (Object)this._moRef)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_privilegeAvailabilities = ", (Object)this._privilegeAvailabilities)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_error = ", (Object)this._error)), (boolean)false) + "\n}";
    }
}

