/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.dataHandlers;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.commonData.TestNetworkDrData;
import com.vmware.srm.client.infrastructure.dataHandlers.data.testNetworks.DatacenterNetwork;
import com.vmware.srm.client.infrastructure.dataHandlers.data.testNetworks.NetworkInfo;
import com.vmware.srm.client.infrastructure.dataHandlers.data.testNetworks.TestNetwork;
import com.vmware.srm.client.infrastructure.dataHandlers.data.testNetworks.TestNetworkData;
import com.vmware.srm.client.infrastructure.dataHandlers.data.testNetworks.TestNetworkRequestData;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.SrmRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.utils.NetworkUtil;
import com.vmware.srm.client.infrastructure.utils.TopologyUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DrInputType(value=TestNetworkRequestData.class)
public abstract class TestNetworksDataHandler
implements SrmRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestNetworksDataHandler.class);

    @Override
    public Promise<? extends DrData> handle(DrData input, SrmRequestContext context) {
        TestNetworkRequestData data = (TestNetworkRequestData)input;
        LOGGER.trace("Getting test network data for recovery site [{}] and recovery plan [{}]", (Object)data.getRecoverySiteRef(), (Object)data.getPlanRef());
        Promise<ManagedObjectReference> vcRootFolderPromise = this.getVcRootFolder(context, data);
        Object view = context.view();
        Promise datacenterDataPromise = vcRootFolderPromise.thenCompose(rootFolder -> this.getDatacenters((ManagedObjectReference)rootFolder, (ServersView)view));
        Promise networkToNameMapPromise = vcRootFolderPromise.thenCompose(rootFolder -> this.getRecoverySiteNetworks((ManagedObjectReference)rootFolder, (ServersView)view));
        Promise networkToIsNsxBackedPromise = networkToNameMapPromise.thenCompose(networkToNameMap -> NetworkUtil.areNsxBacked(networkToNameMap.keySet(), view));
        Promise<Collection<TestNetworkDrData>> testNetworkMappingsPromise = this.retrieveTestNetworkMappings(context, data);
        return Promises.all((Promise[])new Promise[]{datacenterDataPromise, networkToNameMapPromise, networkToIsNsxBackedPromise, testNetworkMappingsPromise}).thenApply(resultAccessor -> {
            Collection datacenterData = (Collection)resultAccessor.getResult(datacenterDataPromise);
            Map networkToNameMap = (Map)resultAccessor.getResult(networkToNameMapPromise);
            Map networkToIsNsxBackedMap = (Map)resultAccessor.getResult(networkToIsNsxBackedPromise);
            Collection testNetworks = (Collection)resultAccessor.getResult(testNetworkMappingsPromise);
            return this.buildTestNetworkData(datacenterData, networkToNameMap, networkToIsNsxBackedMap, testNetworks);
        });
    }

    protected abstract Promise<Collection<TestNetworkDrData>> retrieveTestNetworkMappings(SrmRequestContext var1, TestNetworkRequestData var2);

    protected abstract boolean isLocalTestNetworkData(SrmRequestContext var1, TestNetworkRequestData var2);

    private Promise<ManagedObjectReference> getVcRootFolder(SrmRequestContext context, TestNetworkRequestData data) {
        boolean isLocal = this.isLocalTestNetworkData(context, data);
        return TopologyUtil.getSrmServer(context, !isLocal).thenApply(ExtensionServer::vc).thenApply(Server::service).thenCompose(Service::getContent).thenApply(ServiceInstanceContent::getRootFolder);
    }

    private Promise<Collection<DatacenterData>> getDatacenters(ManagedObjectReference vcRoot, ServersView view) {
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(vcRoot, true);
        ObjectSpecBuilder.TraversalSpecBuilder getChildrenTraversalBuilder = specBuilder.traverseTo("childEntity");
        getChildrenTraversalBuilder.loopTo(getChildrenTraversalBuilder.getName());
        PropertyCollector.ObjectSpec objSpec = specBuilder.build();
        PropertyCollector.PropertySpec propertySpec = PCUtil.createPropertySpec("Datacenter", "name", "network");
        PropertyCollector.FilterSpec filterSpec = PCUtil.createFilterSpec(objSpec, propertySpec);
        LOGGER.trace("getDatacenters");
        HashMap datacenterDataMap = new HashMap();
        Promise<PcResult> pcResultPromise = PCUtil.retrieveProperties(view, filterSpec);
        return pcResultPromise.thenApply(pcResult -> {
            for (ManagedObjectReference dcMoref : pcResult.getMoRefs()) {
                DatacenterData data = datacenterDataMap.computeIfAbsent(dcMoref, k -> new DatacenterData());
                data.datacenterRef = dcMoref;
                data.datacenterName = (String)pcResult.getProperty(dcMoref, "name");
                data.networks = (ManagedObjectReference[])pcResult.getProperty(dcMoref, "network");
                LOGGER.debug("Datacenter Ref: {}, name: {}.", (Object)dcMoref, (Object)data.datacenterName);
                LOGGER.debug("Datacenter Ref: {}, networks count: {}.", (Object)dcMoref, (Object)(data.networks != null ? data.networks.length : 0));
            }
            return datacenterDataMap.values();
        });
    }

    private Promise<Map<ManagedObjectReference, String>> getRecoverySiteNetworks(ManagedObjectReference vcRoot, ServersView view) {
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(vcRoot, true);
        ObjectSpecBuilder.TraversalSpecBuilder getChildrenTraversalBuilder = specBuilder.traverseTo("childEntity");
        ObjectSpecBuilder.TraversalSpecBuilder networkFolderSpecBuilder = getChildrenTraversalBuilder.traverseTo("Datacenter", "networkFolder", true);
        networkFolderSpecBuilder.loopTo(getChildrenTraversalBuilder.getName());
        getChildrenTraversalBuilder.loopTo(getChildrenTraversalBuilder.getName());
        PropertyCollector.ObjectSpec objSpec = specBuilder.build();
        PropertyCollector.PropertySpec propertySpec = PCUtil.createPropertySpec("Network", "name", "tag");
        PropertyCollector.FilterSpec filterSpec = PCUtil.createFilterSpec(objSpec, propertySpec);
        Promise<PcResult> pcResultPromise = PCUtil.retrieveProperties(view, filterSpec);
        return pcResultPromise.thenApply(pcResult -> {
            HashMap networkToNameMap = new HashMap();
            pcResult.getMoRefs().forEach(moRef -> {
                Tag[] tags = (Tag[])pcResult.getProperty((ManagedObjectReference)moRef, "tag");
                if (!NetworkUtil.isUplinkPortgroup(tags)) {
                    String recoveryNetworkName = (String)pcResult.getProperty((ManagedObjectReference)moRef, "name");
                    networkToNameMap.put(moRef, recoveryNetworkName);
                    LOGGER.trace("Network Ref: {}, name: {}.", (Object)moRef.getValue(), (Object)recoveryNetworkName);
                }
            });
            return networkToNameMap;
        });
    }

    private TestNetworkData buildTestNetworkData(Collection<DatacenterData> datacentersData, Map<ManagedObjectReference, String> networkToNameMap, Map<ManagedObjectReference, Boolean> networkToIsNsxBacked, Collection<TestNetworkDrData> testNetworkMappings) {
        boolean hasNetworkMapping;
        LOGGER.trace("buildTestNetworkData");
        HashMap<ManagedObjectReference, ManagedObjectReference> testNetworksMap = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        boolean bl = hasNetworkMapping = testNetworkMappings != null;
        if (hasNetworkMapping) {
            for (TestNetworkDrData mapping : testNetworkMappings) {
                testNetworksMap.put(mapping.getKey(), mapping.getTestNetwork());
            }
        }
        ArrayList<TestNetwork> testNetworks = new ArrayList<TestNetwork>();
        ArrayList<DatacenterNetwork> datacenterNetworks = new ArrayList<DatacenterNetwork>();
        for (DatacenterData dcData : datacentersData) {
            if (ArrayUtils.isEmpty((Object[])dcData.networks)) continue;
            ArrayList<NetworkInfo> networks = new ArrayList<NetworkInfo>();
            for (ManagedObjectReference networkRef : dcData.networks) {
                boolean addToList;
                boolean isNetworkSuitable = networkToNameMap.containsKey(networkRef);
                boolean bl2 = addToList = isNetworkSuitable || hasNetworkMapping && testNetworksMap.containsKey(networkRef);
                if (!addToList) continue;
                TestNetwork testNetwork = this.getTestNetwork(networkToNameMap, networkToIsNsxBacked, testNetworksMap, hasNetworkMapping, dcData, networkRef);
                testNetworks.add(testNetwork);
                if (!isNetworkSuitable) continue;
                networks.add(this.getNetworkInfo(testNetwork));
            }
            DatacenterNetwork datacenterNetwork = new DatacenterNetwork();
            datacenterNetwork.setDatacenterRef(new MoRefData(dcData.datacenterRef));
            datacenterNetwork.setNetworks(networks.toArray(new NetworkInfo[networks.size()]));
            datacenterNetworks.add(datacenterNetwork);
            LOGGER.trace("datacenterNetwork: ", (Object)datacenterNetwork);
        }
        TestNetworkData result = new TestNetworkData();
        result.setTestNetworks(testNetworks.toArray(new TestNetwork[testNetworks.size()]));
        result.setDatacenterNetworks(datacenterNetworks.toArray(new DatacenterNetwork[datacenterNetworks.size()]));
        result.setTestNetworkMappings(TestNetworkData.convertTestNetworkMapping(testNetworkMappings));
        return result;
    }

    private TestNetwork getTestNetwork(Map<ManagedObjectReference, String> networkToNameMap, Map<ManagedObjectReference, Boolean> networkToIsNsxBackedMap, Map<ManagedObjectReference, ManagedObjectReference> testNetworksMap, boolean hasNetworkMapping, DatacenterData dcData, ManagedObjectReference networkRef) {
        ManagedObjectReference testNetworkRef;
        TestNetwork testNetwork = new TestNetwork();
        testNetwork.setDatacenterRef(new MoRefData(dcData.datacenterRef));
        testNetwork.setDatacenterName(dcData.datacenterName);
        testNetwork.setRecoveryNetworkRef(new MoRefData(networkRef));
        testNetwork.setRecoveryNetworkName(this.getNetworkName(networkToNameMap, networkRef));
        testNetwork.setRecoveryNetworkNsxBacked(networkToIsNsxBackedMap.containsKey(networkRef) && networkToIsNsxBackedMap.get(networkRef) != false);
        testNetwork.setDisplayName(testNetwork.getDatacenterName() + " > " + testNetwork.getRecoveryNetworkName());
        if (hasNetworkMapping && (testNetworkRef = testNetworksMap.get(networkRef)) != null) {
            testNetwork.setTestNetworkRef(new MoRefData(testNetworkRef));
            testNetwork.setTestNetworkName(this.getNetworkName(networkToNameMap, testNetwork.getTestNetworkRef()));
            testNetwork.setTestNetworkNsxBacked(networkToIsNsxBackedMap.containsKey(testNetworkRef) && networkToIsNsxBackedMap.get(testNetworkRef) != false);
        }
        LOGGER.trace("testNetwork: ", (Object)testNetwork);
        return testNetwork;
    }

    private NetworkInfo getNetworkInfo(TestNetwork testNetwork) {
        NetworkInfo networkInfo = new NetworkInfo();
        networkInfo.setNetworkName(testNetwork.getRecoveryNetworkName());
        networkInfo.setNetworkRef(new MoRefData(testNetwork.getRecoveryNetworkRef()));
        networkInfo.setNetworkNsxBacked(testNetwork.isRecoveryNetworkNsxBacked());
        LOGGER.trace("networkInfo: ", (Object)networkInfo);
        return networkInfo;
    }

    private String getNetworkName(Map<ManagedObjectReference, String> networkToNameMap, ManagedObjectReference networkRef) {
        String result = networkToNameMap.get(networkRef);
        if (result == null) {
            result = L10N.localize("resourceName.notFound", networkRef.getValue());
        }
        return result;
    }

    private static final class DatacenterData {
        ManagedObjectReference datacenterRef;
        String datacenterName;
        ManagedObjectReference[] networks;

        private DatacenterData() {
        }
    }
}

