/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.dataHandlers;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.dataHandlers.data.VcSiteName;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcSiteNameProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcSiteNameProvider.class);

    public static Promise<VcSiteName> getVcName(ExtensionServer extensionServer) {
        LOGGER.debug("Getting local VCenter server name and moRef for: [{}].", (Object)extensionServer.guid());
        VcServer vcServer = extensionServer.vc();
        return vcServer.getName().thenCompose(name -> {
            VcSiteName vcSiteName = new VcSiteName();
            vcSiteName.setSiteName((String)name);
            return ((VcService)vcServer.service()).getContent().thenApply(ServiceInstanceContent::getRootFolder).thenApply(ref -> {
                vcSiteName.setRootFolderRef(new MoRefData((ManagedObjectReference)ref));
                return vcSiteName;
            });
        });
    }
}

