/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.exceptions;

import com.vmware.srm.client.infrastructure.exceptions.CompositeException;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.utils.ManagedObjectUtil;
import com.vmware.srm.client.infrastructure.utils.PrivilegeUtil;
import com.vmware.srm.client.infrastructure.utils.VcVmodlUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.impl.common.SrmNotAuthenticatedException;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    private static final String NEW_LINE_SEPARATOR = "\n";
    private static final String NO_PERMISSION_MESSAGE_FORMAT_KEY = "NoPermission.message.format";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtil.class);

    public static Exception combine(Exception[] exceptions, Exception ... other) {
        if (ArrayUtils.isEmpty((Object[])exceptions)) {
            return ExceptionUtil.combine(other);
        }
        if (ArrayUtils.isEmpty((Object[])other)) {
            return ExceptionUtil.combine(exceptions);
        }
        return ExceptionUtil.combine((Exception[])ArrayUtils.addAll((Object[])exceptions, (Object[])other));
    }

    public static Exception combine(Exception ... exceptions) {
        if (ArrayUtils.isEmpty((Object[])exceptions)) {
            return null;
        }
        int index = -1;
        for (Exception exc : exceptions) {
            if (exc == null) continue;
            exceptions[++index] = exc;
        }
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return exceptions[index];
        }
        if (index == exceptions.length - 1) {
            return new CompositeException(exceptions);
        }
        CompositeException result = new CompositeException(Arrays.copyOf(exceptions, index + 1));
        return result;
    }

    public static RuntimeException getNoConnectionError(URI url) {
        String location = "";
        if (url != null) {
            location = url.toString();
        }
        String message = L10N.localize("noConnectionToServer", location);
        return new RuntimeException(message);
    }

    public static RuntimeException getSrmNotFoundException() {
        String message = L10N.localize("srmNotFoundErrorMessage", new Object[0]);
        return new RuntimeException(message);
    }

    public static RuntimeException getSrmNotPairedException(String srmGuid) {
        String message = L10N.localize("srmNotPairedErrorMessage", srmGuid);
        return new RuntimeException(message);
    }

    public static RuntimeException getRuntimeException(String localizableMessage) {
        Validate.notEmpty((String)localizableMessage);
        String message = L10N.localize(localizableMessage, new Object[0]);
        return new RuntimeException(message);
    }

    public static RuntimeException getRuntimeException() {
        return new RuntimeException();
    }

    public static RuntimeException getRuntimeException(String errorMessage, Throwable cause) {
        return new RuntimeException(errorMessage, cause);
    }

    public static <T> Promise<T> checkNotAuthenticated(Promise<T> promise) {
        return promise.materialize().thenCompose(promiseResult -> {
            if (promiseResult.isSuccessful()) {
                return Promises.resolve((Object)promiseResult.getResult());
            }
            Throwable ex = promiseResult.getError();
            if (ex instanceof PcResult.PcResultException) {
                ex = ex.getCause();
            }
            if (ex instanceof ExtensionServersView.ServerByPairSetupException) {
                ExtensionServersView.ServerByPairSetupException sbpsExc = (ExtensionServersView.ServerByPairSetupException)ex;
                for (PairSetup ps : sbpsExc.getPairSetups()) {
                    if (!(sbpsExc.getCause(ps) instanceof NotAuthenticated)) continue;
                    return Promises.reject((Exception)sbpsExc.getCause(ps));
                }
            }
            return Promises.reject((Exception)Exceptions.wrap((Throwable)ex));
        });
    }

    public static String getDetailedMessage(Exception ex) {
        if (ex == null) {
            return "";
        }
        int depth = 8;
        Throwable exceptionToProcess = ex;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth && (exceptionToProcess = exceptionToProcess.getCause()) != null; ++i) {
            if (exceptionToProcess.getLocalizedMessage() == null) continue;
            if (i > 0) {
                builder.append(NEW_LINE_SEPARATOR);
            }
            builder.append(exceptionToProcess.getLocalizedMessage());
        }
        return builder.toString();
    }

    public static Promise<Exception> checkNoPermission(Exception ex, ServersView view) {
        if (!(ex instanceof SrmNotAuthenticatedException) && ex instanceof NoPermission) {
            LOGGER.info("Replacing exception '{}' with custom no permission exception.", (Throwable)ex);
            try {
                return ExceptionUtil.createNoPermissionException((NoPermission)ex, view);
            }
            catch (Exception inner) {
                LOGGER.warn("Unable to replace exception '{}' with custom no permission exception, cause: '{}'.", (Object)ex, (Object)inner);
                ex.addSuppressed(inner);
            }
        }
        return Promises.resolve((Object)ex);
    }

    public static <T> T getCausedBy(Exception ex, Class<T> clazz) {
        if (ex == null) {
            return null;
        }
        for (Throwable t = ex; t != null; t = t.getCause()) {
            if (!clazz.isInstance(t)) continue;
            return clazz.cast(t);
        }
        return null;
    }

    private static Promise<Exception> createNoPermissionException(NoPermission noPermissionFault, ServersView view) {
        return ExceptionUtil.buildMessage(noPermissionFault, view).thenApply(RuntimeException::new).materialize().thenApply(pr -> {
            if (pr.isSuccessful()) {
                return (Exception)pr.getResult();
            }
            return noPermissionFault;
        });
    }

    private static Promise<String> buildMessage(NoPermission noPermissionFault, ServersView view) {
        StringBuilder builder = new StringBuilder();
        String faultMessage = noPermissionFault.getMessage();
        if (faultMessage != null) {
            builder.append(faultMessage);
            builder.append(NEW_LINE_SEPARATOR);
        }
        return ExceptionUtil.getNoPermissionFaultMessage(noPermissionFault, view).thenApply(localizedMessage -> {
            builder.append((String)localizedMessage);
            return builder.toString();
        });
    }

    private static Promise<String> getNoPermissionFaultMessage(NoPermission noPermissionFault, ServersView view) {
        String privilegeId = noPermissionFault.getPrivilegeId();
        String privilegeText = PrivilegeUtil.getPrivilegeText(privilegeId);
        ManagedObjectReference moRef = noPermissionFault.getObject();
        return ExceptionUtil.convertHmsMoRefToVc(noPermissionFault.getObject(), view).thenCompose(convertedRef -> PCUtil.retrieveProperties(view, convertedRef, "name").thenApply(pcResult -> {
            String type;
            String objectName = (String)pcResult.tryGetProperty((ManagedObjectReference)convertedRef, "name");
            if (objectName == null) {
                objectName = moRef.toString();
            }
            try {
                type = ManagedObjectUtil.getLocalizedEntityType(convertedRef.getType());
            }
            catch (Exception exc) {
                type = moRef.getType();
            }
            String messageFormat = L10N.localize(NO_PERMISSION_MESSAGE_FORMAT_KEY, new Object[0]);
            return String.format(messageFormat, privilegeText, type, objectName);
        }));
    }

    private static Promise<ManagedObjectReference> convertHmsMoRefToVc(ManagedObjectReference moRef, ServersView view) {
        return view.getServerBy(moRef.getServerGuid()).thenApply(server -> {
            if (HmsServer.class.isInstance(server)) {
                HmsServer hms = (HmsServer)server;
                return VcVmodlUtil.getRootFolder(hms.vc().guid());
            }
            return moRef;
        });
    }
}

