/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.health;

import com.vmware.srm.client.infrastructure.health.HealthData;
import com.vmware.srm.client.infrastructure.http.AsyncControllerUtils;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.http.WriteListenerPromise;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrClientProtocolException;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.utilities.Exceptions;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckController
extends BaseAsyncController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckController.class);
    private final Supplier<Promise<HealthData>> _dataSupplier;
    private final WriteListenerPromise _writeListener;

    public HealthCheckController(HttpServletRequest request, HttpServletResponse response, Supplier<Promise<HealthData>> dataSupplier) {
        super(request, response);
        ServletOutputStream outputStream;
        this._dataSupplier = dataSupplier;
        try {
            outputStream = response.getOutputStream();
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        this._writeListener = new WriteListenerPromise(outputStream);
    }

    private BaseAsyncController.HttpProcessStage createSerializeStage(HealthData data) {
        return () -> {
            byte[] toSend;
            try {
                toSend = SerializationUtil.toByteArray(data);
            }
            catch (Exception e) {
                LOGGER.error("Response serialization failed.", (Throwable)e);
                throw new DrClientProtocolException("Unable to serialize response.", e);
            }
            return Streams.just((Object[])new BaseAsyncController.HttpProcessStage[]{AsyncControllerUtils.createSendStage(toSend, this._response, this._writeListener)});
        };
    }

    @Override
    protected BaseAsyncController.HttpProcessStage createPipeline() {
        ServletOutputStream outputStream;
        try {
            outputStream = this._response.getOutputStream();
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        outputStream.setWriteListener((WriteListener)this._writeListener);
        return () -> this._dataSupplier.get().toStream().map(this::createSerializeStage);
    }
}

