/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.srm.client.infrastructure.http.HttpUtils;
import com.vmware.srm.client.infrastructure.http.ReadListenerPromise;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.http.WriteListenerPromise;
import com.vmware.srm.client.infrastructure.requestHandlers.context.DrRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrClientProtocolException;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrResponse;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrResponseImpl;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncController<T extends DrRequestContext<?>> {
    private static final String MIME_TYPE_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncController.class);
    private static final long DEFAULT_RESPONSE_TIMEOUT = 60000L;
    protected final HttpServletRequest _request;
    protected final HttpServletResponse _response;
    private final Class<? extends DrData> _inputClass;

    public AsyncController(HttpServletRequest request, HttpServletResponse response, Class<? extends DrData> inputClass) {
        this._request = request;
        this._response = response;
        this._inputClass = inputClass;
    }

    public Promise<Void> start() {
        return this.start(60000L);
    }

    public Promise<Void> start(long timeout) {
        ServletOutputStream outputStream;
        this.setResponseHeaders();
        AsyncContext context = this._request.startAsync();
        context.setTimeout(timeout);
        context.addListener((AsyncListener)new ContextListener(HttpUtils.getPath(this._request)));
        Promise<DrData> input = this.getInputData(Config.get().getMaxRequestSize());
        try {
            outputStream = this._response.getOutputStream();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get output stream", (Throwable)e);
            return Promises.reject((Exception)new DrClientProtocolException("Unable to get output stream", e));
        }
        WriteListenerPromise writePromise = new WriteListenerPromise(outputStream);
        outputStream.setWriteListener((WriteListener)writePromise);
        Promise requestContext = Promises.resolve((Object)this).thenCompose(AsyncController::getContext);
        return input.thenCombineCompose(requestContext, this::getResponseValue).materialize().thenApply(promiseResult -> {
            if (promiseResult.isSuccessful()) {
                return DrResponseImpl.create((DrData)promiseResult.getResult());
            }
            Exception exc = promiseResult.getError();
            if (exc instanceof DrClientProtocolException) {
                throw (DrClientProtocolException)exc;
            }
            if (exc instanceof ContextFailedException) {
                throw (ContextFailedException)exc;
            }
            return DrResponseImpl.create(exc);
        }).thenApply(this::processResult).onError(exc -> this.sendInternalServerError((Exception)exc, this._response)).thenCompose(writePromise::setInputBuffer).materialize().thenApply(promiseResult -> {
            context.complete();
            return null;
        });
    }

    protected abstract Promise<? extends DrData> getResponseValue(DrData var1, T var2);

    protected abstract Promise<? extends T> getContext();

    private void setResponseHeaders() {
        this._response.setHeader("Content-type", MIME_TYPE_JSON);
        this._response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
    }

    private DrData processInput(byte[] content) {
        DrData data;
        try {
            data = SerializationUtil.fromByteArray(content, this._inputClass);
        }
        catch (Exception e) {
            LOGGER.error("Parsing request input failed.", (Throwable)e);
            throw new DrClientProtocolException("Unable to parse request input.", e);
        }
        data.validate();
        return data;
    }

    private Promise<DrData> getInputData(int maxRequestSize) {
        if (this._inputClass == null) {
            return Promises.resolve(null);
        }
        if (MIME_TYPE_JSON.equals(this._request.getContentType())) {
            ServletInputStream inputStream;
            try {
                inputStream = this._request.getInputStream();
            }
            catch (IOException e) {
                return Promises.reject((Exception)new DrClientProtocolException("Unable to get input stream", e));
            }
            ReadListenerPromise readListener = new ReadListenerPromise(inputStream, maxRequestSize);
            inputStream.setReadListener((ReadListener)readListener);
            return readListener.materialize().thenApply(pr -> {
                if (pr.isSuccessful()) {
                    return this.processInput((byte[])pr.getResult());
                }
                throw new DrClientProtocolException(pr.getError());
            });
        }
        String msg = String.format("Invalid content type '%s'.", this._request.getContentType());
        return Promises.reject((Exception)new DrClientProtocolException(msg));
    }

    private byte[] processResult(DrResponse result) {
        try {
            return SerializationUtil.toByteArray(result);
        }
        catch (Exception e) {
            LOGGER.error("Response serialization failed.", (Throwable)e);
            throw new DrClientProtocolException("Unable to serialize response.", e);
        }
    }

    protected void sendInternalServerError(Exception exc, HttpServletResponse response) {
        Promises.resolve((Object)exc).onSuccess(err -> LOGGER.error("Request processing for '{}' failed.", (Object)this._request, err));
        try {
            response.sendError(500);
        }
        catch (IOException e) {
            LOGGER.error("Failed to send response to client.", (Throwable)e);
        }
    }

    private static final class ContextListener
    implements AsyncListener {
        private final String _path;

        ContextListener(String path) {
            this._path = path;
        }

        public void onComplete(AsyncEvent event) {
            LOGGER.debug("Processing of request to '{}' completed", (Object)this._path);
        }

        public void onTimeout(AsyncEvent event) {
            LOGGER.error("Processing of request to '{}' timed out", (Object)this._path);
        }

        public void onError(AsyncEvent event) {
            LOGGER.error("Error occured while processing of request to {}", (Object)this._path, (Object)event.getThrowable());
        }

        public void onStartAsync(AsyncEvent event) {
            LOGGER.debug("Processing of request to '{}' started", (Object)this._path);
        }
    }

    public static class ContextFailedException
    extends RuntimeException {
        public ContextFailedException(Exception cause) {
            super(cause);
        }
    }
}

