/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

public class SerializationUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);

    public static <T> T fromByteArray(byte[] inputBuffer, Class<T> inputClass) throws IOException {
        if (inputClass == null) {
            throw new IllegalArgumentException("No input class.");
        }
        if (inputBuffer == null || inputBuffer.length == 0) {
            throw new IllegalArgumentException("No input data.");
        }
        Object data = MAPPER.readValue(inputBuffer, inputClass);
        return (T)data;
    }

    public static <T> byte[] toByteArray(T data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("No data.");
        }
        return MAPPER.writeValueAsBytes(data);
    }
}

