/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.CachingStream;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.StreamImpl;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collection;
import org.apache.commons.lang.Validate;

public class RetrievePropertiesImpl {
    private static final PropertyCollector.RetrieveOptions RETRIEVE_OPTIONS = new PropertyCollector.RetrieveOptions(Integer.valueOf(100));
    private final Service<?, ?> _service;
    private final PropertyCollector.FilterSpec[] _specs;
    private final String _guid;

    RetrievePropertiesImpl(String guid, Service<?, ?> service, Collection<PropertyCollector.FilterSpec> specs) {
        Validate.notNull(service, (String)"service");
        Validate.notEmpty(specs, (String)"specs");
        this._service = service;
        this._specs = specs.toArray(new PropertyCollector.FilterSpec[specs.size()]);
        this._guid = guid;
    }

    public String getGuid() {
        return this._guid;
    }

    public PropertyCollector.FilterSpec[] getFilterSpec() {
        return this._specs;
    }

    public Promise<Collection<PropertyCollector.RetrieveResult>> retrieveProperties() {
        return PCUtil.getPropertyCollectorRef(this._service).thenCompose(pcRef -> {
            PropertyCollector pc = (PropertyCollector)this._service.createStub(pcRef);
            CachingStream results = new CachingStream();
            FuturePromise getResult = new FuturePromise();
            getResult.onSuccess(arg_0 -> this.lambda$null$219((StreamImpl)results, pc, arg_0)).onError(arg_0 -> ((StreamImpl)results).publishError(arg_0));
            pc.retrievePropertiesEx(this._specs, RETRIEVE_OPTIONS, (Future)getResult);
            return results.collect();
        });
    }

    private void retrievePropertiesEx(StreamImpl<PropertyCollector.RetrieveResult> results, PropertyCollector pc, PropertyCollector.RetrieveResult prevResult) {
        if (prevResult.token != null) {
            FuturePromise getResult = new FuturePromise();
            getResult.onSuccess(retrieveResult -> {
                results.publishNext(retrieveResult);
                this.retrievePropertiesEx(results, pc, (PropertyCollector.RetrieveResult)retrieveResult);
            }).onError(arg_0 -> results.publishError(arg_0));
            pc.continueRetrievePropertiesEx(prevResult.token, (Future)getResult);
        } else {
            results.publishComplete();
        }
    }

    private /* synthetic */ void lambda$null$219(StreamImpl streamImpl, PropertyCollector propertyCollector, PropertyCollector.RetrieveResult retrieveResult) {
        if (retrieveResult != null) {
            streamImpl.publishNext((Object)retrieveResult);
            this.retrievePropertiesEx((StreamImpl<PropertyCollector.RetrieveResult>)streamImpl, propertyCollector, retrieveResult);
        } else {
            streamImpl.publishComplete();
        }
    }
}

