/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.providers;

import com.vmware.srm.client.infrastructure.commonData.FolderInventoryData;
import com.vmware.srm.client.infrastructure.commonData.InventoryData;
import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.inventory.InventoryTreePathDelegateProvider;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import com.vmware.srm.client.infrastructure.utils.ManagedObjectUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.vc.VcServersView;
import com.vmware.vim.binding.dr.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryTreePathDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryTreePathDataProvider.class);
    private SrmRequestContext _context;
    private InventoryTreePathDelegateProvider _delegateProvider;

    public InventoryTreePathDataProvider(SrmRequestContext context, InventoryTreePathDelegateProvider delegateProvider) {
        this._context = context;
        this._delegateProvider = delegateProvider;
    }

    public Promise<? extends DrDataList<FolderInventoryData>> getInventoryTreePath(MoRefData requestNode) {
        return this.getTreePath((VcServersView)this._context.view(), requestNode).materialize().thenCompose(promiseResult -> {
            if (!promiseResult.isSuccessful()) {
                RuntimeException e = new RuntimeException(this._delegateProvider.getLocalizedGenericErrorMessage(requestNode), promiseResult.getError());
                LOGGER.error("Error in PC for node: {}", (Object)requestNode, (Object)e);
                throw e;
            }
            return this.handlePcResult((PcResult)promiseResult.getResult(), requestNode, this._context);
        }).thenApply(this::sortInventoryData);
    }

    protected Promise<PcResult> getTreePath(VcServersView view, MoRefData requestNode) {
        ObjectSpecBuilder specBuilder = this._delegateProvider.getSpecBuilder(requestNode);
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec(this._delegateProvider.getPropertySpecs(), new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
        return PCUtil.retrieveProperties((ServersView)view, filterSpec);
    }

    protected Promise<DrDataList<FolderInventoryData>> handlePcResult(PcResult pcResult, MoRefData requestNode, SrmRequestContext context) {
        Exception dataRetrievalEx = pcResult.getErrorForGuid(requestNode.getServerGuid());
        if (dataRetrievalEx != null) {
            RuntimeException e = new RuntimeException(this._delegateProvider.getLocalizedGenericErrorMessage(requestNode), dataRetrievalEx);
            LOGGER.error("Error in PC for node: {}", (Object)requestNode, (Object)e);
            throw e;
        }
        HashMap<ManagedObjectReference, InventoryData> items = new HashMap<ManagedObjectReference, InventoryData>();
        FolderInventoryData rootFolder = null;
        List<String> filterTypes = this._delegateProvider.getFilterTypes();
        Collection objectRefs = pcResult.getMoRefs();
        if (!CollectionUtils.isEmpty(filterTypes)) {
            objectRefs = objectRefs.stream().filter(item -> filterTypes.contains(item.getType())).collect(Collectors.toList());
        }
        for (ManagedObjectReference nodeRef : objectRefs) {
            InventoryData invData = items.computeIfAbsent(nodeRef, unused -> this._delegateProvider.getDefaultInventoryData(nodeRef));
            ManagedObjectReference parent = (ManagedObjectReference)pcResult.getProperty(nodeRef, "parentEntity");
            if (this._delegateProvider.isRootFolder(nodeRef)) {
                rootFolder = (FolderInventoryData)invData;
                continue;
            }
            if (parent == null) continue;
            InventoryData parentItem = items.computeIfAbsent(parent, unused -> this._delegateProvider.getDefaultInventoryData(parent));
            ((FolderInventoryData)parentItem).addChild(invData);
        }
        return this._delegateProvider.fillInventoryDataFromPcResult((Map<ManagedObjectReference, InventoryData>)items, pcResult, (ServersView)this._context.view()).thenCombineCompose(Promises.resolve(rootFolder), (resultItems, root) -> {
            if (root != null) {
                return this.getRootFolders(context, (FolderInventoryData)root);
            }
            RuntimeException e = new RuntimeException(this._delegateProvider.getLocalizedGenericErrorMessage(requestNode));
            LOGGER.error("Could not find root node for object: {}", (Object)requestNode, (Object)e);
            throw e;
        });
    }

    protected Promise<DrDataList<FolderInventoryData>> getRootFolders(SrmRequestContext context, FolderInventoryData rootFolder) {
        Promise handlerResult = context.dispatch(this._delegateProvider.getRootFolderHandlerPath(), null);
        return handlerResult.thenApply(rootFolders -> {
            for (FolderInventoryData folder : rootFolders) {
                if (!folder.getMoRef().equals(rootFolder.getMoRef())) continue;
                folder.setChildren(rootFolder.getChildren());
            }
            return rootFolders;
        });
    }

    protected DrDataList<FolderInventoryData> sortInventoryData(DrDataList<FolderInventoryData> inventoryDatas) {
        for (InventoryData inventoryData : inventoryDatas) {
            this.sortInventoryData(inventoryData);
        }
        return inventoryDatas;
    }

    protected void sortInventoryData(InventoryData inventoryData) {
        if (!(inventoryData instanceof FolderInventoryData) || ((FolderInventoryData)inventoryData).getChildren() == null) {
            return;
        }
        FolderInventoryData folderInvData = (FolderInventoryData)inventoryData;
        folderInvData.getChildren().sort((left, right) -> {
            if (left.getMoRef().getType().equals(right.getMoRef().getType())) {
                if (left.getName() == null) {
                    return -1;
                }
                if (right.getName() == null) {
                    return 1;
                }
                return left.getName().compareTo(right.getName());
            }
            if (this._delegateProvider.getFolderMorefType().equals(left.getMoRef().getType()) || ManagedObjectUtil.isOfType(left.getMoRef(), Folder.class)) {
                return -1;
            }
            return 1;
        });
        for (InventoryData child : folderInvData.getChildren()) {
            this.sortInventoryData(child);
        }
    }
}

