/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.navigation;

import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.CertificateIssueException;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.ErrorData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

@DrInputType
public class ErrorsRequestHandler
implements FreeRequestHandler {
    @Override
    public Promise<? extends DrData> handle(DrData input, FreeRequestContext context) {
        return context.view().getLocalServers().filter(ExtensionServer.class::isInstance).map(server -> (ExtensionServer)server).flatMap(this::checkServer).map(this::convert).collect().thenApply(DrDataList::new);
    }

    private Stream<Exception> checkServer(VcServer vc) {
        return ((VcService)vc.service()).getServiceInstance().thenCompose(si -> {
            FuturePromise timePromise = new FuturePromise();
            si.currentTime((Future)timePromise);
            return timePromise;
        }).materialize().thenApply(result -> {
            if (result.isSuccessful()) {
                return null;
            }
            return result.getError();
        }).toStream().flatMap(exc -> {
            if (exc == null) {
                return Streams.empty();
            }
            return Streams.just((Object[])new Exception[]{exc});
        });
    }

    private Stream<Exception> checkServer(ExtensionServer<?> ext) {
        Stream<Exception> vcStream = this.checkServer(ext.vc());
        List<Exception> certExceptions = this.checkServerCertificates(ext);
        return ext.getPairs().materialize().flatMap(event -> {
            switch (event.type) {
                case error: {
                    return Streams.just((Object[])new Exception[]{event.error});
                }
            }
            return Streams.empty();
        }).merge(new Publisher[]{vcStream, Streams.from(certExceptions)});
    }

    private List<Exception> checkServerCertificates(ExtensionServer<?> ext) {
        List<Exception> vcExceptions = this.checkServerCertificates((Server<?>)ext.vc(), "certificate.error.vc");
        String extKey = ext instanceof HmsServer ? "certificate.error.vr" : (ext instanceof SrmServer ? "certificate.error.srm" : "certificate.error.unknown");
        List<Exception> extExceptions = this.checkServerCertificates((Server<?>)ext, extKey);
        return java.util.stream.Stream.of(vcExceptions, extExceptions).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    private List<Exception> checkServerCertificates(Server<?> server, String errKey) {
        if (CollectionUtils.isEmpty((Collection)server.certificateIssues())) {
            return Collections.emptyList();
        }
        return server.certificateIssues().stream().filter(CertificateValidityInfo::isBad).map(certificateValidityInfo -> this.getCertificateException(errKey, server.service().getServerUrl().toString(), (CertificateValidityInfo)certificateValidityInfo)).collect(Collectors.toList());
    }

    private Exception getCertificateException(String serverNameKey, String serverUrl, CertificateValidityInfo info) {
        Validate.isTrue((boolean)info.isBad());
        String msgKey = info.getStatus() == CertificateValidityInfo.Status.Expired ? "certificate.error.expired" : "certificate.error.bad";
        String serverName = L10N.localize(serverNameKey, new Object[0]);
        return new CertificateIssueException(L10N.localize(msgKey, serverName, serverUrl), info.getError());
    }

    private ErrorData convert(Throwable exc) {
        ErrorData fault = new ErrorData();
        String msg = exc.getLocalizedMessage();
        if (StringUtils.isEmpty((String)msg)) {
            msg = exc.toString();
        }
        fault.setMessage(msg);
        Throwable cause = exc.getCause();
        if (cause == null) {
            return fault;
        }
        String detail = cause.getLocalizedMessage();
        if (StringUtils.isEmpty((String)detail)) {
            detail = cause.toString();
        }
        fault.setDetail(detail);
        return fault;
    }
}

