/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.tasks.FakeTask;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.common.SyncUtils;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeTaskRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeTaskRegistry.class);
    private static final long TIMER_INTERVAL = 600000L;
    private static final Map<ManagedObjectReference, FakeTask> _tasks = new ConcurrentHashMap<ManagedObjectReference, FakeTask>();
    private static Timer _timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTask(FakeTask task) {
        if (task == null) {
            throw new IllegalArgumentException("task");
        }
        Class<FakeTaskRegistry> clazz = FakeTaskRegistry.class;
        synchronized (FakeTaskRegistry.class) {
            LOGGER.trace("Registering task: {}", (Object)task._getRef());
            _tasks.put(task._getRef(), task);
            if (_timer == null) {
                LOGGER.debug("Starting timer");
                _timer = new Timer(true);
                _timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        FakeTaskRegistry.timerTick();
                    }
                }, 600000L, 600000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Task getTask(ManagedObjectReference taskRef) {
        if (!"VmodlFakeTask".equals(taskRef.getType())) {
            return null;
        }
        if (!_tasks.containsKey(taskRef)) {
            return null;
        }
        return _tasks.get(taskRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void timerTick() {
        Class<FakeTaskRegistry> clazz = FakeTaskRegistry.class;
        synchronized (FakeTaskRegistry.class) {
            LOGGER.debug("Starting removal of stale fake tasks.");
            Iterator<FakeTask> it = _tasks.values().iterator();
            while (it.hasNext()) {
                long then;
                long now;
                Task task = it.next();
                FuturePromise fp = new FuturePromise();
                task.getInfo((Future)fp);
                TaskInfo info = (TaskInfo)SyncUtils.getSync((Promise)fp);
                if (!TaskInfo.State.success.equals((Object)info.state) && !TaskInfo.State.error.equals((Object)info.state) || (now = Calendar.getInstance().getTimeInMillis()) - (then = info.completeTime.getTimeInMillis()) <= 600000L) continue;
                LOGGER.trace("Removing stale task: {}", (Object)task._getRef());
                it.remove();
            }
            if (_tasks.isEmpty() && _timer != null) {
                LOGGER.debug("Stopping timer - no more tasks.");
                _timer.cancel();
                _timer = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

